/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.time;

import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import jdplus.toolkit.base.api.time.TemporalFormatter;
import jdplus.toolkit.base.api.time.TimeInterval;
import jdplus.toolkit.base.api.time.TimeIntervalFormatter;
import jdplus.toolkit.base.api.time.TimeIntervalQuery;
import jdplus.toolkit.base.api.time.TimeRecurrence;
import jdplus.toolkit.base.api.time.TimeRecurrenceAccessor;
import jdplus.toolkit.base.api.time.TimeRecurrenceQuery;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TimeRecurrenceFormatter {
    @NonNull
    private final TimeIntervalFormatter intervalFormatter;
    @NonNull
    private final TimeIntervalQuery<? extends TimeInterval<?, ?>> intervalQuery;
    private static final char RECURRENCE_CHAR = 'R';
    private static final char RECURRENCE_SEPARATOR = '/';

    @NonNull
    public String format(@NonNull TimeRecurrence<?> timeRecurrence) throws DateTimeException {
        if (timeRecurrence == null) {
            throw new NullPointerException("timeRecurrence is marked non-null but is null");
        }
        return this.format(timeRecurrence, null);
    }

    @NonNull
    public String format(@NonNull TimeRecurrence<?> timeRecurrence, @Nullable ChronoUnit precision) throws DateTimeException {
        if (timeRecurrence == null) {
            throw new NullPointerException("timeRecurrence is marked non-null but is null");
        }
        StringBuilder result = new StringBuilder(32);
        this.formatTo(timeRecurrence, result, precision);
        return result.toString();
    }

    public void formatTo(@NonNull TimeRecurrence<?> timeRecurrence, @NonNull Appendable appendable) throws DateTimeException {
        if (timeRecurrence == null) {
            throw new NullPointerException("timeRecurrence is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        this.formatTo(timeRecurrence, appendable, null);
    }

    public void formatTo(@NonNull TimeRecurrence<?> timeRecurrence, @NonNull Appendable appendable, @Nullable ChronoUnit precision) throws DateTimeException {
        if (timeRecurrence == null) {
            throw new NullPointerException("timeRecurrence is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        TemporalFormatter.appendTo('R', appendable);
        TemporalFormatter.appendTo(String.valueOf(timeRecurrence.length()), appendable);
        TemporalFormatter.appendTo('/', appendable);
        this.intervalFormatter.formatTo((TimeInterval<?, ?>)timeRecurrence.getInterval(), appendable, precision);
    }

    @NonNull
    public <R extends TimeRecurrence<?>> R parse(@NonNull CharSequence text, @NonNull TimeRecurrenceQuery<R> query) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (text.charAt(0) != 'R') {
            throw new DateTimeParseException("Cannot found recurrence character", text, 0);
        }
        int index = TimeRecurrenceFormatter.getRecurrenceSeparatorIndex(text);
        final CharSequence left = text.subSequence(1, index);
        final CharSequence right = text.subSequence(index + 1, text.length());
        TimeRecurrence result = (TimeRecurrence)query.queryFrom(new TimeRecurrenceAccessor(){

            @Override
            @NonNull
            public TimeInterval<?, ?> getInterval() {
                return TimeRecurrenceFormatter.this.intervalFormatter.parse(right, TimeRecurrenceFormatter.this.intervalQuery);
            }

            @Override
            public int length() {
                return TimeRecurrenceFormatter.parseLength(left);
            }
        });
        if (result == null) {
            throw new DateTimeException("Unable to obtain TimeRecurrence from TimeRecurrenceQuery");
        }
        return (R)result;
    }

    private static int getRecurrenceSeparatorIndex(CharSequence text) throws DateTimeParseException {
        int intervalDesignatorIdx = TimeIntervalFormatter.indexOf(text, '/');
        if (intervalDesignatorIdx == -1) {
            throw new DateTimeParseException("Cannot find recurrence separator", text, 0);
        }
        return intervalDesignatorIdx;
    }

    private static int parseLength(CharSequence text) throws DateTimeParseException {
        try {
            return Integer.parseInt(text.toString());
        }
        catch (NumberFormatException ex) {
            throw new DateTimeParseException("Cannot parse length", text, 0, ex);
        }
    }

    @Generated
    private TimeRecurrenceFormatter(@NonNull TimeIntervalFormatter intervalFormatter, @NonNull TimeIntervalQuery<? extends TimeInterval<?, ?>> intervalQuery) {
        if (intervalFormatter == null) {
            throw new NullPointerException("intervalFormatter is marked non-null but is null");
        }
        if (intervalQuery == null) {
            throw new NullPointerException("intervalQuery is marked non-null but is null");
        }
        this.intervalFormatter = intervalFormatter;
        this.intervalQuery = intervalQuery;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TimeRecurrenceFormatter of(@NonNull TimeIntervalFormatter intervalFormatter, @NonNull TimeIntervalQuery<? extends TimeInterval<?, ?>> intervalQuery) {
        if (intervalFormatter == null) {
            throw new NullPointerException("intervalFormatter is marked non-null but is null");
        }
        if (intervalQuery == null) {
            throw new NullPointerException("intervalQuery is marked non-null but is null");
        }
        return new TimeRecurrenceFormatter(intervalFormatter, intervalQuery);
    }
}

