/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class AtomHybridizationVSEPRDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#atomHybridizationVSEPR", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return new String[]{"hybr"};
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        IAtomType atomType;
        try {
            atomType = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)atom.getBuilder()).findMatchingAtomType(container, atom);
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(0), this.getDescriptorNames(), (Exception)((Object)new CDKException("Atom type was null")));
        }
        if (atomType == null) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(0), this.getDescriptorNames(), (Exception)((Object)new CDKException("Atom type was null")));
        }
        if (atomType.getHybridization() == null) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(0), this.getDescriptorNames(), (Exception)((Object)new CDKException("Hybridization was null")));
        }
        int hybridizationCDK = atomType.getHybridization().ordinal();
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(hybridizationCDK), this.getDescriptorNames());
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }
}

