## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message = FALSE---------------------------------------------------
library(prmisc)
library(effectsize)
library(afex)

## -----------------------------------------------------------------------------
ttest <- t.test(1:10, y = c(7:20), var.equal = TRUE)
library("effectsize") # for Cohen's d
cohend <- cohens_d(1:10, c(7:20))
print_ttest(ttest, cohend) 

## -----------------------------------------------------------------------------
data(sleep) # ?sleep
tt <- t.test(sleep$extra[sleep$group == 1], 
             sleep$extra[sleep$group == 2], paired = TRUE)
cd <- cohens_d(sleep$extra[sleep$group == 1], 
               sleep$extra[sleep$group == 2], paired = TRUE)
print_ttest(tt, cd)

## -----------------------------------------------------------------------------
print_ttest(tt, cd, confidence = TRUE)

## -----------------------------------------------------------------------------
cd <- cohens_d(sleep$extra[sleep$group == 1], 
               sleep$extra[sleep$group == 2], paired = TRUE, ci = .8)
print_ttest(tt, cd, confidence = TRUE)

## -----------------------------------------------------------------------------
print_ttest(tt)

## -----------------------------------------------------------------------------
x <- c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1)
y <- c( 2.6,  3.1,  2.5,  5.0,  3.6,  4.0,  5.2,  2.8,  3.8)
cor_results <- cor.test(x, y)
print_cortest(cor_results)

## -----------------------------------------------------------------------------
library("afex")
# see ?aov_ez
data(md_12.1)
aov_results <- aov_ez("id", "rt", md_12.1, within = c("angle", "noise"))

print_anova(aov_results) # returns a list with all effects in this ANOVA

## -----------------------------------------------------------------------------
print_anova(aov_results, italic_eta = FALSE)

## -----------------------------------------------------------------------------
print_anova(
  aov_ez("id", "rt", md_12.1, within = c("angle", "noise"),
         anova_table = list(es = "pes"))
)
print_anova(
  aov_ez("id", "rt", md_12.1, within = c("angle", "noise"),
         anova_table = list(es = "none"))
)

## -----------------------------------------------------------------------------
x <- matrix(c(12, 5, 7, 7), ncol = 2)
print_chi2(x) # does not use continuity correction by default

## -----------------------------------------------------------------------------
print_chi2(x, correct = TRUE) # use continuity correction

## -----------------------------------------------------------------------------
print_chi2(x, es = FALSE) 

## -----------------------------------------------------------------------------
print_chi2(x, italic_greek = FALSE) 

## -----------------------------------------------------------------------------
force_decimals(c(1.23456, 0.873, 2.3456, 1.2), decimals = 2)

## -----------------------------------------------------------------------------
force_decimals(c(0.004, 0.001, 0.0005, 0.02))
force_decimals(c(0.004, 0.001, 0.0005, 0.02), round_zero = FALSE)

## -----------------------------------------------------------------------------
force_or_cut(c(1:3, 1.23456, 0.873, 2.3456), decimals = 2)

## -----------------------------------------------------------------------------
force_decimals(c(1:3, 1.23456, 0.873, 2.3456), decimals = 2)

## -----------------------------------------------------------------------------
decimals_only(c(0.23456, 0.873, 0.3456), decimals = 3)

## -----------------------------------------------------------------------------
format_p(0.03123)

## -----------------------------------------------------------------------------
format_p(0.000001231, 3)

## -----------------------------------------------------------------------------
format_p(0.3123, decimals = 2)

## -----------------------------------------------------------------------------
format_p(c(0.3123, 0.001, 0.00001, 0.19))

## -----------------------------------------------------------------------------
format_p(c(.999, .9999, 1))

## -----------------------------------------------------------------------------
print_mean_sd(iris$Sepal.Length)

