/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.GenericModelReader;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceModel
extends BaseModel {
    private static final String COMPONENT_NAME = "SentenceDetectorME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "sent.model";

    public SentenceModel(String languageCode, AbstractModel sentModel, Map<String, String> manifestInfoEntries, SentenceDetectorFactory sdFactory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, sdFactory);
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, sentModel);
        this.checkArtifactMap();
    }

    public SentenceModel(String languageCode, AbstractModel sentModel, boolean useTokenEnd, Dictionary abbreviations, char[] eosCharacters, Map<String, String> manifestInfoEntries) {
        this(languageCode, sentModel, manifestInfoEntries, new SentenceDetectorFactory(languageCode, useTokenEnd, abbreviations, eosCharacters));
    }

    public SentenceModel(String languageCode, AbstractModel sentModel, boolean useTokenEnd, Dictionary abbreviations, char[] eosCharacters) {
        this(languageCode, sentModel, useTokenEnd, abbreviations, eosCharacters, null);
    }

    public SentenceModel(String languageCode, AbstractModel sentModel, boolean useTokenEnd, Dictionary abbreviations, Map<String, String> manifestInfoEntries) {
        this(languageCode, sentModel, useTokenEnd, abbreviations, null, manifestInfoEntries);
    }

    public SentenceModel(String languageCode, AbstractModel sentModel, boolean useTokenEnd, Dictionary abbreviations) {
        this(languageCode, sentModel, useTokenEnd, abbreviations, null, null);
    }

    public SentenceModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public SentenceModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public SentenceModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Unable to find sent.model maxent model!");
        }
        if (!ModelUtil.validateOutcomes(this.getMaxentModel(), "s", "n")) {
            throw new InvalidFormatException("The maxent model is not compatible with the sentence detector!");
        }
    }

    public SentenceDetectorFactory getFactory() {
        return (SentenceDetectorFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return SentenceDetectorFactory.class;
    }

    public AbstractModel getMaxentModel() {
        return (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
    }

    public Dictionary getAbbreviations() {
        if (this.getFactory() != null) {
            return this.getFactory().getAbbreviationDictionary();
        }
        return null;
    }

    public boolean useTokenEnd() {
        if (this.getFactory() != null) {
            return this.getFactory().isUseTokenEnd();
        }
        return true;
    }

    public char[] getEosCharacters() {
        if (this.getFactory() != null) {
            return this.getFactory().getEOSCharacters();
        }
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, InvalidFormatException {
        if (args.length < 3) {
            System.err.println("SentenceModel [-abbreviationsDictionary] [-useTokenEnd] languageCode packageName modelName");
            System.exit(1);
        }
        int ai = 0;
        Dictionary abbreviations = null;
        if ("-abbreviationsDictionary".equals(args[ai])) {
            int n = ++ai;
            ++ai;
            abbreviations = new Dictionary(new FileInputStream(args[n]));
        }
        boolean useTokenEnd = false;
        if ("-useTokenEnd".equals(args[ai])) {
            useTokenEnd = true;
        }
        int n = ++ai;
        String languageCode = args[n];
        int n2 = ++ai;
        String packageName = args[n2];
        String modelName = args[++ai];
        AbstractModel model = new GenericModelReader(new File(modelName)).getModel();
        SentenceModel packageModel = new SentenceModel(languageCode, model, useTokenEnd, abbreviations, (char[])null);
        packageModel.serialize(new FileOutputStream(packageName));
    }
}

