/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.tools.coref.CorefSample;
import opennlp.tools.coref.mention.DefaultParse;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.MentionFinder;
import opennlp.tools.coref.mention.PTBHeadFinder;
import opennlp.tools.coref.mention.PTBMentionFinder;
import opennlp.tools.formats.muc.MucCorefContentHandler;
import opennlp.tools.formats.muc.RawCorefSample;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MucMentionInserterStream
extends FilterObjectStream<RawCorefSample, CorefSample> {
    private static Set<String> entitySet = new HashSet<String>(Arrays.asList(DefaultParse.NAME_TYPES));
    private final MentionFinder mentionFinder = PTBMentionFinder.getInstance(PTBHeadFinder.getInstance());

    protected MucMentionInserterStream(ObjectStream<RawCorefSample> samples) {
        super(samples);
    }

    private static Span getMinSpan(Parse p, MucCorefContentHandler.CorefMention mention) {
        String min = mention.min;
        if (min != null) {
            int startOffset = p.toString().indexOf(min);
            int endOffset = startOffset + min.length();
            Parse[] tokens = p.getTagNodes();
            int beginToken = -1;
            int endToken = -1;
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].getSpan().getStart() == startOffset) {
                    beginToken = i;
                }
                if (tokens[i].getSpan().getEnd() != endOffset) continue;
                endToken = i + 1;
                break;
            }
            if (beginToken != -1 && endToken != -1) {
                return new Span(beginToken, endToken);
            }
        }
        return null;
    }

    public static boolean addMention(int id, Span mention, Parse[] tokens) {
        Parse endToken;
        boolean failed = false;
        Parse startToken = tokens[mention.getStart()];
        Parse commonParent = startToken.getCommonParent(endToken = tokens[mention.getEnd() - 1]);
        if (commonParent != null) {
            if (entitySet.contains(commonParent.getType())) {
                commonParent.getParent().setType("NP#" + id);
            } else if (commonParent.getType().equals("NML")) {
                commonParent.setType("NML#" + id);
            } else if (commonParent.getType().equals("NP")) {
                commonParent.setType("NP#" + id);
            } else {
                System.out.println("Inserting mention failed: " + commonParent.getType() + " Failed id: " + id);
                failed = true;
            }
        } else {
            throw new IllegalArgumentException("Tokens must always have a common parent!");
        }
        return !failed;
    }

    @Override
    public CorefSample read() throws IOException {
        RawCorefSample sample = (RawCorefSample)this.samples.read();
        if (sample != null) {
            ArrayList<Parse> mentionParses = new ArrayList<Parse>();
            List<MucCorefContentHandler.CorefMention[]> allMentions = sample.getMentions();
            List<Parse> allParses = sample.getParses();
            for (int si = 0; si < allMentions.size(); ++si) {
                MucCorefContentHandler.CorefMention[] mentions = allMentions.get(si);
                Parse p = allParses.get(si);
                for (Mention extent : this.mentionFinder.getMentions(new DefaultParse(p, si))) {
                    if (extent.getParse() != null) continue;
                    Parse snp = new Parse(p.getText(), extent.getSpan(), "NML", 1.0, 0);
                    p.insert(snp);
                }
                Parse[] tokens = p.getTagNodes();
                for (MucCorefContentHandler.CorefMention mention : mentions) {
                    Span min = MucMentionInserterStream.getMinSpan(p, mention);
                    if (min == null) {
                        min = mention.span;
                    }
                    MucMentionInserterStream.addMention(mention.id, min, tokens);
                }
                p.show();
                mentionParses.add(p);
            }
            return new CorefSample(mentionParses);
        }
        return null;
    }
}

