/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search.stopcriteria;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.stopcriteria.StopCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopCriterionChecker {
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread t = new Thread(runnable, "stop-crit-checker");
        t.setDaemon(true);
        return t;
    });
    private StopCriterionCheckTask runningTask;
    private ScheduledFuture<?> runningTaskFuture;
    private final Object runningTaskLock = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(StopCriterionChecker.class);
    private long period;
    private TimeUnit periodTimeUnit;
    private final Search<?> search;
    private final List<StopCriterion> stopCriteria;

    public StopCriterionChecker(Search<?> search) {
        this.search = search;
        this.stopCriteria = new ArrayList<StopCriterion>();
        this.period = 1L;
        this.periodTimeUnit = TimeUnit.SECONDS;
        this.runningTask = null;
    }

    public void add(StopCriterion stopCriterion) {
        stopCriterion.searchShouldStop(this.search);
        this.stopCriteria.add(stopCriterion);
    }

    public boolean remove(StopCriterion stopCriterion) {
        return this.stopCriteria.remove(stopCriterion);
    }

    public void clear() {
        this.stopCriteria.clear();
    }

    public void setPeriod(long period, TimeUnit timeUnit) {
        this.period = period;
        this.periodTimeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startChecking() {
        Object object = this.runningTaskLock;
        synchronized (object) {
            if (this.runningTask == null) {
                if (!this.stopCriteria.isEmpty()) {
                    this.runningTask = new StopCriterionCheckTask();
                    this.runningTaskFuture = SCHEDULER.scheduleWithFixedDelay(this.runningTask, this.period, this.period, this.periodTimeUnit);
                    LOGGER.debug("Stop criterion checker for search {} activated", (Object)this.search);
                }
            } else {
                LOGGER.warn("Attempted to activate already active stop criterion checker for search {}", (Object)this.search);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopChecking() {
        Object object = this.runningTaskLock;
        synchronized (object) {
            if (this.runningTask != null) {
                this.runningTaskFuture.cancel(false);
                LOGGER.debug("Stop criterion checker for search {} deactivated", (Object)this.search);
                this.runningTask = null;
                this.runningTaskFuture = null;
            }
        }
    }

    public boolean stopCriterionSatisfied() {
        int i;
        for (i = 0; i < this.stopCriteria.size() && !this.stopCriteria.get(i).searchShouldStop(this.search); ++i) {
        }
        return i < this.stopCriteria.size();
    }

    private class StopCriterionCheckTask
    implements Runnable {
        private StopCriterionCheckTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = StopCriterionChecker.this.runningTaskLock;
            synchronized (object) {
                if (StopCriterionChecker.this.runningTask == this) {
                    if (StopCriterionChecker.this.stopCriterionSatisfied()) {
                        StopCriterionChecker.this.stopChecking();
                        LOGGER.debug("Requesting search {} to stop", (Object)StopCriterionChecker.this.search);
                        StopCriterionChecker.this.search.stop();
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Aborting cancelled stop criterion check task @{} for search {} (currently scheduled task: @{})", Integer.toHexString(this.hashCode()), StopCriterionChecker.this.search, Integer.toHexString(StopCriterionChecker.this.runningTask.hashCode()));
                }
            }
        }
    }
}

