/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.eco.Determinant;
import ec.tstoolkit.ssf.DiffuseState;
import ec.tstoolkit.ssf.DiffuseVarianceFilter;
import ec.tstoolkit.ssf.FastState;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.IDiffuseFilteringResults;
import ec.tstoolkit.ssf.IFastFilteringResults;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ResidualsCumulator;
import ec.tstoolkit.ssf.State;

public class DiffuseFilteringResults
extends ResidualsCumulator
implements IFilteringResults,
IFastFilteringResults,
IDiffuseFilteringResults {
    private final DiffuseVarianceFilter m_var;
    private final FilteredData m_fdata;
    private final Determinant m_ddet = new Determinant();

    public DiffuseFilteringResults() {
        this.m_var = new DiffuseVarianceFilter();
        this.m_fdata = new FilteredData();
    }

    public DiffuseFilteringResults(boolean hasC) {
        this.m_var = new DiffuseVarianceFilter(hasC);
        this.m_fdata = new FilteredData();
    }

    @Override
    public void clear() {
        this.m_fdata.clear();
        this.m_var.clear();
        super.clear();
        this.m_ddet.clear();
    }

    @Override
    public void close() {
        this.m_var.close();
    }

    @Override
    public void closeDiffuse() {
        this.m_var.closeDiffuse();
    }

    public int getDiffuseCount() {
        return this.m_var.m_ndiffuse;
    }

    public double getDiffuseLogDeterminant() {
        return this.m_ddet.getLogDeterminant();
    }

    public int getEndDiffusePosition() {
        return this.m_var.m_enddiffusepos;
    }

    public FilteredData getFilteredData() {
        return this.m_fdata;
    }

    public DiffuseVarianceFilter getVarianceFilter() {
        return this.m_var;
    }

    @Override
    public void prepare(ISsf ssf, ISsfData data) {
        if (this.m_var.isOpen()) {
            this.m_fdata.checkSize(data.getCount());
        } else {
            this.m_fdata.init(ssf.getStateDim(), data.getCount());
            this.m_ddet.clear();
            super.clear();
        }
        this.m_var.prepare(ssf, data);
    }

    @Override
    public void prepareDiffuse(ISsf ssf, ISsfData data) {
        this.clear();
        this.m_var.prepareDiffuse(ssf, data);
        this.m_fdata.init(ssf.getStateDim(), ssf.getNonStationaryDim());
    }

    @Override
    public void save(int t, DiffuseState state) {
        this.m_var.save(t, state);
        this.m_fdata.checkSize(t + 1);
        this.m_fdata.save(t, state);
        if (!state.isMissing()) {
            if (state.fi > 0.0) {
                this.m_ddet.add(state.fi);
            } else {
                super.add(state.e, state.f);
            }
        }
    }

    @Override
    public void save(int t, FastState state) {
        this.m_var.save(t, state);
        this.m_fdata.save(t, state);
        if (!state.isMissing()) {
            super.add(state.e, state.f);
        }
    }

    @Override
    public void save(int t, State state) {
        this.m_var.save(t, state);
        this.m_fdata.save(t, state);
        if (!state.isMissing()) {
            super.add(state.e, state.f);
        }
    }
}

