## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----supported_data_models----------------------------------------------------
library(ReviewR)
ReviewR::supported_data_models

## ----table_1, echo=FALSE, fig.cap = "*Table 1: OMOP v5.3.0 Schema obtained from [OHDSI](https://github.com/OHDSI/CommonDataModel/releases/tag/v5.3.0)*", fig.align='center'----
suppressMessages(library(magrittr))
ReviewR::supported_data_models %>% 
  dplyr::filter(data_model == 'omop', model_version == 'v5.3.0') %>% 
  tidyr::unnest(cols = data) %>% 
  dplyr::ungroup() %>% 
  dplyr::select(table, field) %>% 
  DT::datatable(rownames = FALSE)

## ----figure_1, echo=FALSE, fig.cap = '*Patient information tabsets on the "Chart Review" tab of ReviewR are generated by table functions.*', fig.align="center"----
knitr::include_graphics('chart_review_tabs.png')

## ---- eval=F------------------------------------------------------------------
#  omop_table_all_patients <- function(table_map, db_connection) {
#    user_table(table_map, db_connection, 'person') %>%
#      mutate(ID = user_field(table_map, 'person', 'person_id')) %>%
#      collect()
#  }

## ---- eval=F------------------------------------------------------------------
#  omop_table_condition_occurrence <- function(table_map, db_connection, subject_id) {
#    user_table(table_map, db_connection, 'person') %>%
#      filter(ID == subject_id) %>%
#      collect()
#  }

## ----eval=FALSE---------------------------------------------------------------
#  # install.packages('usethis')
#  usethis::create_from_github(repo_spec = 'thewileylab/ReviewR', destdir = '~/')

## ----eval=FALSE---------------------------------------------------------------
#  # install.packages('devtools')
#  devtools::load_all()

## ---- eval=F------------------------------------------------------------------
#  ReviewR:::dev_add_data_model(csv = 'path/to/schema/file.csv')

## ---- eval=F------------------------------------------------------------------
#  golem::document_and_reload()

## ---- eval=F------------------------------------------------------------------
#  omop_table_all_patients <- function(table_map, db_connection) {
#    user_table(table_map, db_connection, 'person') %>%
#      mutate(ID = user_field(table_map, 'person', 'person_id')) %>%
#      left_join(user_table(table_map, db_connection, 'person'),
#                by=setNames(user_field(table_map, 'person', 'gender_concept_id'), user_field(table_map, 'concept', 'concept_id'))
#                ) %>%
#      collect()
#  }

## ----eval=FALSE---------------------------------------------------------------
#  golem::document_and_reload()
#  ReviewR::run_app()

## ----eval=FALSE---------------------------------------------------------------
#  devtools::install()

