/*
 * Decompiled with CFR 0.152.
 */
package dsa;

import dsa.Node;
import dsa.NodeTreeModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class NodeTreeComponent
extends JComponent
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(NodeTreeComponent.class.getName());
    private NodeTreeModel model;
    private TreeBox treeBox;
    private Font font;
    private List<ActionListener> listenerList;
    private int eventID = 0;

    public NodeTreeComponent(NodeTreeModel model) {
        this.model = model;
        this.treeBox = model.getNode() != null ? new TreeBox(model.getNode(), model.getSelected()) : null;
        this.font = new Font("SansSerif", 1, 14);
        this.addMouseListener(new MouseHandler());
        model.addPropertyChangeListener(this);
        this.listenerList = new ArrayList<ActionListener>();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 160);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(140, 100);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.treeBox != null) {
            logger.log(Level.FINE, "calling treeBox.display");
            Dimension d = this.getSize();
            this.treeBox.setdim(0.0, 0.0, d.width, d.height);
            this.treeBox.display(g2, null);
        } else {
            logger.log(Level.FINE, "treeBox is null");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.model.getNode() != null) {
            logger.log(Level.FINE, "constructing a new treeBox");
            this.treeBox = new TreeBox(this.model.getNode(), this.model.getSelected());
        } else {
            logger.log(Level.FINE, "setting treeBox to null");
            this.treeBox = null;
        }
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        if (l != null) {
            this.listenerList.remove(l);
        }
    }

    public ActionListener[] getActionListeners() {
        return this.listenerList.toArray(new ActionListener[0]);
    }

    protected void fireActionPerformed(ActionEvent event) {
        for (ActionListener l : this.listenerList) {
            l.actionPerformed(event);
        }
    }

    class TreeBox {
        private final Node node;
        private final Node selected;
        private final TreeBox left;
        private final TreeBox right;
        private double xorigin;
        private double yorigin;
        private double width;
        private double height;
        private Double lwidth;
        private Double lheight;
        private boolean fixed;

        TreeBox(Node node, Node selected) {
            assert (node != null);
            this.node = node;
            this.selected = selected;
            if (node.left != null && node.right != null) {
                this.left = new TreeBox(node.left, selected);
                this.right = new TreeBox(node.right, selected);
                double cheight = Math.max(this.left.getLHeight(), this.right.getLHeight());
                this.left.setLHeight(cheight);
                this.right.setLHeight(cheight);
                this.lwidth = null;
                this.lheight = null;
            } else {
                this.left = null;
                this.right = null;
                this.lwidth = 1.0;
                this.lheight = 1.0;
            }
            this.fixed = false;
        }

        boolean display(Graphics2D g2, Point2D.Double pcoord) {
            Color textColor;
            Color nodeColorDark;
            Color nodeColorLight;
            assert (this.fixed);
            assert (this.node != null);
            boolean selectedPath = false;
            boolean leafNode = this.getLeft() == null || this.getRight() == null;
            Point2D.Double p = new Point2D.Double(this.getX(), this.getY());
            if (!leafNode) {
                if (this.getLeft().display(g2, p)) {
                    selectedPath = true;
                }
                if (this.getRight().display(g2, p)) {
                    selectedPath = true;
                }
            }
            if (this.node == this.selected || this.node.pname() != null && this.node.pname().equals(this.selected.pname())) {
                selectedPath = true;
            }
            if (pcoord != null) {
                Line2D.Double line = new Line2D.Double(pcoord, p);
                float thickness = selectedPath ? 5.0f : 2.0f;
                BasicStroke stroke = new BasicStroke(thickness);
                g2.setStroke(stroke);
                Color lineColor = selectedPath ? new Color(247, 186, 92) : new Color(50, 56, 60);
                g2.setPaint(lineColor);
                g2.draw(line);
            }
            String msg = "???";
            if (this.node != null) {
                msg = this.node.split != null ? this.node.split.toString() : this.node.toString();
            }
            FontRenderContext context = g2.getFontRenderContext();
            LineMetrics metrics = NodeTreeComponent.this.font.getLineMetrics(msg, context);
            Rectangle2D bounds = NodeTreeComponent.this.font.getStringBounds(msg, context);
            double border = 4.0;
            double w = bounds.getWidth() + 2.0 * border;
            double h = bounds.getHeight() + 2.0 * border;
            double arc = h / 2.0;
            double x1 = p.x - w / 2.0;
            double y1 = p.y - h / 2.0;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x1, y1, w, h, arc, arc);
            RoundRectangle2D.Double shadow = new RoundRectangle2D.Double(x1 + 2.0, y1 + 4.0, w, h, arc, arc);
            Color shadowColor = new Color(50, 56, 60, 100);
            g2.setPaint(shadowColor);
            g2.fill(shadow);
            if (leafNode) {
                if (this.node == this.selected) {
                    nodeColorLight = new Color(62, 117, 108);
                    nodeColorDark = new Color(19, 102, 88);
                    textColor = Color.white;
                } else if (this.node.pname() != null && this.node.pname().equals(this.selected.pname())) {
                    nodeColorLight = new Color(62, 117, 108);
                    nodeColorDark = new Color(19, 102, 88);
                    textColor = Color.white;
                } else {
                    nodeColorLight = new Color(135, 206, 194);
                    nodeColorDark = new Color(109, 206, 190);
                    textColor = Color.black;
                }
            } else if (this.node == this.selected) {
                nodeColorLight = new Color(69, 93, 121);
                nodeColorDark = new Color(22, 61, 105);
                textColor = Color.white;
            } else {
                nodeColorLight = new Color(142, 173, 208);
                nodeColorDark = new Color(118, 161, 208);
                textColor = Color.black;
            }
            Point2D.Double lpoint = new Point2D.Double(p.x - h / 6.0, y1);
            Point2D.Double mpoint = new Point2D.Double(p.x + h / 6.0, y1 + h);
            GradientPaint gp = new GradientPaint(lpoint, nodeColorLight, mpoint, nodeColorDark);
            g2.setPaint(gp);
            g2.fill(rect);
            g2.setFont(NodeTreeComponent.this.font);
            g2.setPaint(textColor);
            int ix = (int)(x1 + border);
            int iy = (int)(y1 + border + (double)metrics.getAscent());
            g2.drawString(msg, ix, iy);
            return selectedPath;
        }

        void setLHeight(double lheight) {
            assert (!this.fixed);
            if (this.getLeft() != null && this.getRight() != null) {
                this.getLeft().setLHeight(lheight - 1.0);
                this.getRight().setLHeight(lheight - 1.0);
            } else {
                this.lheight = lheight;
            }
        }

        void setdim(double xorigin, double yorigin, double width, double height) {
            this.fixed = true;
            this.xorigin = xorigin;
            this.yorigin = yorigin;
            this.width = width;
            this.height = height;
            if (this.getLeft() != null && this.getRight() != null) {
                double pheight = 1.0 * height / this.getLHeight();
                double cheight = height - pheight;
                double lcwidth = this.getLeft().getLWidth() * width / this.getLWidth();
                double rcwidth = width - lcwidth;
                this.getLeft().setdim(xorigin, yorigin + pheight, lcwidth, cheight);
                this.getRight().setdim(xorigin + lcwidth, yorigin + pheight, rcwidth, cheight);
            }
        }

        double getLWidth() {
            if (this.lwidth != null) {
                return this.lwidth;
            }
            assert (this.getLeft() != null && this.getRight() != null);
            return this.getLeft().getLWidth() + this.getRight().getLWidth();
        }

        double getWidth() {
            assert (this.fixed);
            return this.width;
        }

        double getLHeight() {
            if (this.lheight != null) {
                return this.lheight;
            }
            double h = 1.0;
            if (this.getLeft() != null && this.getRight() != null) {
                h += Math.max(this.getLeft().getLHeight(), this.getRight().getLHeight());
            }
            return h;
        }

        double getHeight() {
            assert (this.fixed);
            return this.height;
        }

        double getLX() {
            if (this.getLeft() != null && this.getRight() != null) {
                return (this.getLeft().getLWidth() + this.getLeft().getLX() + this.getRight().getLX()) / 2.0;
            }
            return this.getLWidth() / 2.0;
        }

        double getX() {
            assert (this.fixed);
            return this.xorigin + this.getLX() * this.getWidth() / this.getLWidth();
        }

        double getLY() {
            return 0.5;
        }

        double getY() {
            assert (this.fixed);
            return this.yorigin + this.getLY() * this.getHeight() / this.getLHeight();
        }

        TreeBox getLeft() {
            return this.left;
        }

        TreeBox getRight() {
            return this.right;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            String command = "foo";
            NodeTreeComponent.this.fireActionPerformed(new ActionEvent(this, NodeTreeComponent.this.eventID, command));
            NodeTreeComponent.this.eventID += 1;
        }
    }
}

