## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = F,
  comment = "#>"
)
library(dplyr)
library(hablar)

## -----------------------------------------------------------------------------
x <- c(NA, 1, 2)
s(x)

## -----------------------------------------------------------------------------
x <- c(NaN, 1, Inf)
s(x)

## -----------------------------------------------------------------------------
x <- c()
s(x)

## -----------------------------------------------------------------------------
x <- c(NaN, Inf, 3, 4)
median(s(x))

## -----------------------------------------------------------------------------
x <- c(1, 2, 3, 4, 5)
sum(x)

## -----------------------------------------------------------------------------
x <- c(1, 2, 3, NA, 4)
mean(x)


## -----------------------------------------------------------------------------
x <- c(1, 2, 3, NA, 4)
mean(x, na.rm = TRUE)


## -----------------------------------------------------------------------------
x <- c(1, 2, 3, NA, 4)
mean(s(x))


## ---- echo=F------------------------------------------------------------------
df <- tibble(day = c(1, 2, 3, 1, 2, 3, 1, 2, 3),
       name = c(rep("Amanda", 3), rep("David", 3), rep("Viktor", 3)),
       sold_sodas = c(3, NA, 8, NA, NA, NA, 2, 1, 4)) %>% 
  print()

## ---- warning=FALSE-----------------------------------------------------------
df %>% 
  group_by(name) %>% 
  summarize(n_sodas_best_day = max(sold_sodas, na.rm = T))

## ---- warning=FALSE-----------------------------------------------------------
x <- c()
max(x)

## -----------------------------------------------------------------------------
df %>% 
  group_by(name) %>% 
  summarize(n_sodas_best_day = max(sold_sodas))

## -----------------------------------------------------------------------------
df %>% 
  group_by(name) %>% 
  summarize(n_sodas_best_day = max(s(sold_sodas)))

## ---- include = F-------------------------------------------------------------
df <- starwars %>% 
  select(name, homeworld, species, height)

## -----------------------------------------------------------------------------
df %>% head(10)

## ---- warning=FALSE-----------------------------------------------------------
df %>% 
  filter(!is.na(height)) %>% 
  group_by(homeworld) %>% 
  summarize(tallest_human = max(height[species == "Human"]))

## -----------------------------------------------------------------------------
df %>% 
  filter(!is.na(height)) %>% 
  group_by(homeworld) %>% 
  summarize(tallest_human = max(s(height[species == "Human"])))

## -----------------------------------------------------------------------------
x <- c(NaN, 1)
min(x)

## -----------------------------------------------------------------------------
x <- c(Inf, 3, 4)
mean(x)

## -----------------------------------------------------------------------------
x <- c(5, -Inf, 2)
sum(x)

## -----------------------------------------------------------------------------
x <- c(NaN, 1)
min(s(x))

## -----------------------------------------------------------------------------
x <- c(Inf, 3, 4)
mean(s(x))

## -----------------------------------------------------------------------------
x <- c(5, -Inf, 2)
sum(s(x))

## -----------------------------------------------------------------------------
x <- c(NaN, 1)
min_(x)

## -----------------------------------------------------------------------------
x <- c(Inf, 3, 4)
mean_(x)

## -----------------------------------------------------------------------------
x <- c(5, -Inf, 2)
sum_(x)

