/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.grid.regular.square;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.restopt.RasterConnectivityFinder;
import org.restopt.exception.RestoptException;
import org.restopt.grid.regular.square.GroupedGrid;

public class PartialRegularGroupedGrid
extends GroupedGrid {
    private final int[] sizeCells;
    private final int nbGroups;
    private final ISet[] groups;
    private final int nbGroupedCells;
    private final int[] unGroupedId;
    private final Map<Integer, Integer> gridIdToGroupedId;

    public PartialRegularGroupedGrid(int nbRows, int nbCols, int[] toDiscard, RasterConnectivityFinder groupGraph) {
        this(nbRows, nbCols, toDiscard, groupGraph, 4);
    }

    public PartialRegularGroupedGrid(int nbRows, int nbCols, int[] toDiscard, RasterConnectivityFinder groupGraph, int maxNeighCard) {
        super(nbRows, nbCols, toDiscard);
        int cc;
        this.nbGroupedCells = groupGraph.getNbNodes();
        this.nbGroups = groupGraph.getNBCC();
        this.sizeCells = new int[super.getNbCells() - this.nbGroupedCells + this.nbGroups];
        this.groups = new ISet[this.nbGroups];
        for (cc = 0; cc < this.nbGroups; ++cc) {
            int sizeCC;
            this.sizeCells[cc] = sizeCC = groupGraph.getSizeCC()[cc];
            int[] g = groupGraph.getCC(cc);
            for (int i = 0; i < sizeCC; ++i) {
                g[i] = this.getPartialIndex(g[i]);
            }
            this.groups[cc] = SetFactory.makeConstantSet(g);
        }
        this.gridIdToGroupedId = new HashMap<Integer, Integer>();
        for (cc = 0; cc < this.nbGroups; ++cc) {
            ISetIterator sizeCC = this.groups[cc].iterator();
            while (sizeCC.hasNext()) {
                int i = (Integer)sizeCC.next();
                this.gridIdToGroupedId.put(i, cc);
            }
        }
        this.unGroupedId = new int[this.getNbCells() - this.nbGroups];
        int nbNotGrouped = 0;
        for (int i = 0; i < super.getNbCells(); ++i) {
            if (this.gridIdToGroupedId.containsKey(i)) continue;
            this.gridIdToGroupedId.put(i, nbNotGrouped + this.nbGroups);
            this.unGroupedId[nbNotGrouped] = i;
            this.sizeCells[nbNotGrouped + this.nbGroups] = 1;
            ++nbNotGrouped;
        }
    }

    @Override
    public int getNbCells() {
        return super.getNbCells() - this.nbGroupedCells + this.nbGroups;
    }

    public ISet getGroup(int groupId) {
        return this.groups[groupId];
    }

    @Override
    public int[] getSizeCells() {
        return this.sizeCells;
    }

    @Override
    public int getNbGroups() {
        return this.nbGroups;
    }

    public int getUngroupedPartialIndex(int groupedIdx) {
        if (groupedIdx < this.nbGroups) {
            throw new RuntimeException("A grouped cell is not associated to a complete index");
        }
        return this.unGroupedId[groupedIdx - this.nbGroups];
    }

    public int getUngroupedCompleteIndex(int groupedIdx) {
        if (groupedIdx < this.nbGroups) {
            throw new RuntimeException("A grouped cell is not associated to a complete index");
        }
        return this.getCompleteIndex(this.unGroupedId[groupedIdx - this.nbGroups]);
    }

    @Override
    public int[] getUngroupedCompleteIndices(int[] pus) {
        return IntStream.of(pus).map(i -> this.getUngroupedCompleteIndex(i)).toArray();
    }

    public int getGroupIndexFromCompleteIndex(int completeIndex) {
        int partialIndex = this.getPartialIndex(completeIndex);
        return this.gridIdToGroupedId.get(partialIndex);
    }

    @Override
    public int getGroupIndexFromPartialIndex(int partialIndex) {
        return this.gridIdToGroupedId.get(partialIndex);
    }

    @Override
    public double[][] getCartesianCoordinates() {
        double[][] coords = new double[super.getNbCells()][];
        for (int i = 0; i < super.getNbCells(); ++i) {
            int[] coord = super.getCoordinatesFromIndex(i);
            coords[i] = new double[]{coord[1], coord[0]};
        }
        return coords;
    }

    @Override
    public double[] getCartesianCoordinates(int partialGroupedIndex) throws RestoptException {
        if (partialGroupedIndex < this.getNbGroups()) {
            throw new RestoptException("Cannot associate cartesian coordinates to a grouped cell");
        }
        int[] c = super.getCoordinatesFromIndex(this.getUngroupedPartialIndex(partialGroupedIndex));
        return new double[]{c[1], c[0]};
    }

    public double[] getCartesianCoordinatesFromPartialIndex(int partialIndex) {
        int[] c = super.getCoordinatesFromIndex(partialIndex);
        return new double[]{c[1], c[0]};
    }
}

