/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.GammaProcess;
import umontreal.iro.lecuyer.stochprocess.StochasticProcess;
import umontreal.iro.lecuyer.stochprocess.VarianceGammaProcess;
import umontreal.iro.lecuyer.stochprocess.VarianceGammaProcessDiff;

public class GeometricVarianceGammaProcess
extends StochasticProcess {
    protected VarianceGammaProcess vargamma;
    protected double theta;
    protected double nu;
    protected double mu;
    protected double sigma;
    protected double omega;
    protected double muPlusOmega;
    protected double[] mudt;

    public GeometricVarianceGammaProcess(double s0, double theta, double sigma, double nu, double mu, RandomStream stream) {
        this.vargamma = new VarianceGammaProcess(0.0, theta, sigma, nu, stream);
        this.setParams(s0, theta, sigma, nu, mu);
    }

    public GeometricVarianceGammaProcess(double s0, double mu, VarianceGammaProcess vargamma) {
        this.vargamma = vargamma;
        this.setParams(s0, vargamma.getTheta(), vargamma.getSigma(), vargamma.getNu(), mu);
    }

    public double nextObservation() {
        double s;
        double nextX = this.vargamma.nextObservation();
        this.observationIndex = this.vargamma.getCurrentObservationIndex();
        ++this.observationCounter;
        this.path[this.observationIndex] = s = this.x0 * Math.exp(this.muPlusOmega * (this.t[this.observationIndex] - this.t[0]) + nextX);
        return s;
    }

    public double[] generatePath() {
        double s = this.x0;
        this.resetStartProcess();
        double[] vgpath = this.vargamma.generatePath();
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s *= Math.exp(this.mudt[i] + vgpath[i + 1] - vgpath[i]);
        }
        this.observationIndex = this.d;
        ++this.observationCounter;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        double s = this.x0;
        this.resetStartProcess();
        double[] vgpath = this.vargamma.generatePath(uniform01);
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s *= Math.exp(this.mudt[i] + vgpath[i + 1] - vgpath[i]);
        }
        this.observationIndex = this.d;
        ++this.observationCounter;
        return this.path;
    }

    public double getCurrentUpperBound() {
        int j = 0;
        for (int i = this.observationCounter - 1; i > 0; --i) {
            double tForIthObserv = this.t[this.observationIndexFromCounter[i]];
            if (!(tForIthObserv <= this.t[this.observationCounter]) || !(tForIthObserv > this.t[j])) continue;
            j = i;
        }
        double u = 0.0;
        GammaProcess gpos = ((VarianceGammaProcessDiff)this.vargamma).getGpos();
        double[] gposPath = gpos.getPath();
        double deltaGpos = gposPath[this.observationIndex] - gposPath[j];
        double s = this.path[this.observationIndex];
        u = this.muPlusOmega < 0.0 ? s * Math.exp(deltaGpos) : s * Math.exp(this.muPlusOmega * (this.t[this.observationIndex] - this.t[j]) + deltaGpos);
        return u;
    }

    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
        this.vargamma.resetStartProcess();
    }

    public void setParams(double s0, double theta, double sigma, double nu, double mu) {
        this.x0 = s0;
        this.theta = theta;
        this.sigma = sigma;
        this.nu = nu;
        this.mu = mu;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    public double getTheta() {
        return this.theta;
    }

    public double getMu() {
        return this.mu;
    }

    public double getNu() {
        return this.nu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getOmega() {
        return this.omega;
    }

    public VarianceGammaProcess getVarianceGammaProcess() {
        return this.vargamma;
    }

    protected void init() {
        super.init();
        if (1.0 <= this.theta * this.nu + this.sigma * this.sigma * this.nu / 2.0) {
            throw new IllegalArgumentException("theta*nu + sigma*sigma*nu / 2 >= 1");
        }
        this.omega = Math.log(1.0 - this.theta * this.nu - this.sigma * this.sigma * this.nu / 2.0) / this.nu;
        this.muPlusOmega = this.mu + this.omega;
        if (this.observationTimesSet) {
            this.vargamma.setObservationTimes(this.t, this.d);
            this.observationIndexFromCounter = this.vargamma.getArrayMappingCounterToIndex();
            this.mudt = new double[this.d];
            for (int i = 0; i < this.d; ++i) {
                this.mudt[i] = this.muPlusOmega * (this.t[i + 1] - this.t[i]);
            }
        }
    }

    public void setStream(RandomStream stream) {
        this.vargamma.setStream(stream);
    }

    public RandomStream getStream() {
        return this.vargamma.getStream();
    }
}

