/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.structure;

import dr.evolution.coalescent.structure.ColouredTreeIntervals;
import dr.evolution.coalescent.structure.StructuredCoalescent;
import dr.evolution.colouring.ColourChangeMatrix;
import dr.evomodel.coalescent.structure.ColourSamplerModel;
import dr.evomodel.coalescent.structure.MetaPopulationModel;
import dr.evomodel.coalescent.structure.MigrationModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

@Deprecated
public class StructuredCoalescentLikelihood
extends AbstractModelLikelihood {
    public static final String STRUCTURED_COALESCENT_LIKELIHOOD = "structuredCoalescentLikelihood";
    public static final String META_POPULATION_MODEL = "metaPopulationModel";
    public static final String MIGRATION_MODEL = "migrationModel";
    public static final String POPULATION = "population";
    private final Statistic migrationWaitingTimesStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "migrationWaitingTimes";
        }

        @Override
        public int getDimension() {
            return StructuredCoalescentLikelihood.this.metaPopulationModel.getPopulationCount();
        }

        @Override
        public double getStatisticValue(int n) {
            double[] dArray = StructuredCoalescentLikelihood.this.migrationModel.getMigrationRates(0.0);
            return 1.0 / dArray[n];
        }
    };
    private final Statistic coalescentWaitingTimeStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "coalescentWaitingTime";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            double[] dArray = StructuredCoalescentLikelihood.this.metaPopulationModel.getPopulationSizes(0.0);
            int[] nArray = StructuredCoalescentLikelihood.this.colourSamplerModel.getLeafColourCounts();
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += (double)nArray[i] / dArray[i];
            }
            return 1.0 / d;
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class, "The tree."), new ElementRule(ColourSamplerModel.class, "The colour sampler model."), new ElementRule(MigrationModel.class, "The migration model."), new ElementRule(MetaPopulationModel.class, "The meta-population model.")};

        @Override
        public String getParserName() {
            return StructuredCoalescentLikelihood.STRUCTURED_COALESCENT_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            ColourSamplerModel colourSamplerModel = (ColourSamplerModel)xMLObject.getChild(ColourSamplerModel.class);
            MigrationModel migrationModel = (MigrationModel)xMLObject.getChild(MigrationModel.class);
            MetaPopulationModel metaPopulationModel = (MetaPopulationModel)xMLObject.getChild(MetaPopulationModel.class);
            StructuredCoalescentLikelihood structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, metaPopulationModel, colourSamplerModel, migrationModel);
            Logger.getLogger("dr.evomodel").info("Creating structured coalescent tree prior.");
            return structuredCoalescentLikelihood;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a likelihood function for transmission.";
        }

        @Override
        public Class getReturnType() {
            return StructuredCoalescentLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private TreeModel treeModel = null;
    private MetaPopulationModel metaPopulationModel = null;
    private ColourSamplerModel colourSamplerModel = null;
    private MigrationModel migrationModel = null;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;

    public StructuredCoalescentLikelihood(TreeModel treeModel, MetaPopulationModel metaPopulationModel, ColourSamplerModel colourSamplerModel, MigrationModel migrationModel) {
        this(STRUCTURED_COALESCENT_LIKELIHOOD, treeModel, metaPopulationModel, colourSamplerModel, migrationModel);
    }

    public StructuredCoalescentLikelihood(String string, TreeModel treeModel, MetaPopulationModel metaPopulationModel, ColourSamplerModel colourSamplerModel, MigrationModel migrationModel) {
        super(string);
        this.treeModel = treeModel;
        this.addModel(treeModel);
        this.metaPopulationModel = metaPopulationModel;
        this.addModel(metaPopulationModel);
        this.colourSamplerModel = colourSamplerModel;
        this.addModel(colourSamplerModel);
        this.migrationModel = migrationModel;
        this.addModel(migrationModel);
        this.addStatistic(this.migrationWaitingTimesStatistic);
        this.addStatistic(this.coalescentWaitingTimeStatistic);
    }

    @Override
    protected final void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            // empty if block
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected final void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected final void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected final void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        this.likelihoodKnown = false;
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public final void makeDirty() {
        this.likelihoodKnown = false;
    }

    public double calculateLogLikelihood() {
        ColouredTreeIntervals colouredTreeIntervals = new ColouredTreeIntervals(this.treeModel, this.colourSamplerModel.getTreeColouring());
        ColourChangeMatrix colourChangeMatrix = this.migrationModel.getMigrationMatrix();
        StructuredCoalescent structuredCoalescent = new StructuredCoalescent();
        double d = structuredCoalescent.calculateLogLikelihood(this.colourSamplerModel.getTreeColouring(), colouredTreeIntervals, colourChangeMatrix, this.metaPopulationModel);
        return d;
    }
}

