/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.sequence;

import dr.evolution.datatype.DataType;
import dr.evolution.util.Taxon;
import dr.util.Attributable;
import dr.util.Identifiable;
import java.util.Iterator;

public class Sequence
implements Identifiable,
Attributable {
    private Attributable.AttributeHelper attributes = null;
    protected String id = null;
    protected Taxon taxon = null;
    protected StringBuffer sequenceString = new StringBuffer();
    protected DataType dataType = null;

    public Sequence() {
    }

    public Sequence(String string) {
        this.setSequenceString(string);
    }

    public Sequence(Sequence sequence) {
        this(sequence.getTaxon(), sequence.getSequenceString());
    }

    public Sequence(Taxon taxon, String string) {
        this.setTaxon(taxon);
        this.setSequenceString(string);
    }

    public Sequence(Taxon taxon, DataType dataType, int[] nArray) {
        this.setTaxon(taxon);
        this.dataType = dataType;
        this.setSequenceStates(nArray);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getLength() {
        return this.sequenceString.length();
    }

    public String getSequenceString() {
        return this.sequenceString.toString();
    }

    public char getChar(int n) {
        return this.sequenceString.charAt(n);
    }

    public int getState(int n) {
        return this.dataType.getState(this.sequenceString.charAt(n));
    }

    public void setState(int n, int n2) {
        this.sequenceString.setCharAt(n, this.dataType.getChar(n2));
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        this.sequenceString.getChars(n, n2, cArray, n3);
    }

    public int getInvalidChar(DataType dataType) {
        char[] cArray = dataType.getValidChars();
        if (cArray != null) {
            String string = new String(cArray);
            for (int i = 0; i < this.sequenceString.length(); ++i) {
                char c = this.sequenceString.charAt(i);
                if (string.indexOf(c) >= 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType guessDataType() {
        return DataType.guessDataType(this.sequenceString.toString());
    }

    public void setSequenceString(String string) {
        this.sequenceString.setLength(0);
        this.sequenceString.append(string.toUpperCase());
    }

    public void appendSequenceString(String string) {
        this.sequenceString.append(string);
    }

    public void insertSequenceString(int n, String string) {
        this.sequenceString.insert(n, string);
    }

    public void setSequenceStates(int[] nArray) {
        this.sequenceString.setLength(0);
        for (int n : nArray) {
            this.sequenceString.append(this.dataType.getChar(n));
        }
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributeNames();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }
}

