## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
knitr::opts_chunk$set(eval = TRUE)

## ----eval = FALSE-------------------------------------------------------------
#  remotes::install_github("kkawato/rdlearn@0.1.1")

## ----message=FALSE, warning=FALSE---------------------------------------------
library(rdlearn)

## -----------------------------------------------------------------------------
library(rdlearn)

# Load acces data
data(acces)
head(acces)

## -----------------------------------------------------------------------------
rdestimate_result <- rdestimate(
  data = acces,
  y = "elig",
  x = "saber11",
  c = "cutoff",
  group_name = "department"
)
print(rdestimate_result)

## ----warning=FALSE, fig.width = 8, fig.height = 6-----------------------------
# set seed for replication
set.seed(12345) 
# only a subset of data is used
acces_filtered <- acces[acces$department %in% c("DISTRITO CAPITAL", "MAGDALENA"), ]

# To replicate exactly, set data = acces, fold = 20 and M = c(0, 1, 2, 4)
rdlearn_result <- rdlearn(
  data = acces_filtered, 
  y = "elig", # elig
  x = "saber11", # saber11
  c = "cutoff", # cutoff
  group_name = "department",
  fold = 2,
  M = 1,
  cost = 0,
  trace = FALSE
)
summary(rdlearn_result)
plot(rdlearn_result, opt = "dif")

## ----warning=FALSE, fig.width = 8, fig.height = 6-----------------------------
# To replicate exactly, set cost = c(0, 0.2, 0.4, 0.6, 0.8, 1)
sens_result <- sens(
  rdlearn_result,
  M = 1,
  cost = 1,
  trace = FALSE)
plot(sens_result, opt = "dif")

