/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NegativeBinomialDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NegativeBinomialGen
extends RandomVariateGenInt {
    protected double gamma;
    protected double p;

    public NegativeBinomialGen(RandomStream s, double gamma, double p) {
        super(s, new NegativeBinomialDist(gamma, p));
        this.setParams(gamma, p);
    }

    public NegativeBinomialGen(RandomStream s, NegativeBinomialDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getGamma(), dist.getP());
        }
    }

    public static int nextInt(RandomStream s, double gamma, double p) {
        return NegativeBinomialDist.inverseF(gamma, p, s.nextDouble());
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getP() {
        return this.p;
    }

    protected void setParams(double gamma, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        this.p = p;
        this.gamma = gamma;
    }
}

