/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats.diagnostics;

import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovDiagnostics;
import jdplus.tramoseats.base.core.seats.SeatsTests;
import jdplus.tramoseats.base.core.seats.diagnostics.SeatsDiagnosticsConfiguration;
import jdplus.tramoseats.base.core.seats.diagnostics.SeatsDiagnosticsFactory;

public class SeatsDiagnostics
implements Diagnostics {
    private WienerKolmogorovDiagnostics diags;
    private double bad = 0.005;
    private double uncertain = 0.05;
    private boolean same;
    private boolean cutoff;
    private static final int I_CMP = 3;
    private static final int S_CMP = 2;

    public static SeatsDiagnostics of(SeatsDiagnosticsConfiguration config, SeatsTests srslts) {
        try {
            if (srslts == null) {
                return null;
            }
            SeatsDiagnostics sd = new SeatsDiagnostics(config, srslts);
            if (sd.isValid()) {
                return sd;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public SeatsDiagnostics(SeatsDiagnosticsConfiguration config, SeatsTests rslts) {
        this.bad = config.getBadThreshold();
        this.uncertain = config.getUncertainThreshold();
        this.test(rslts);
    }

    private void test(SeatsTests srslts) {
        this.same = !srslts.isModelChanged();
        this.cutoff = srslts.isParametersCutOff();
        this.diags = srslts.wkDiagnostics();
    }

    public WienerKolmogorovDiagnostics getDiagnostics() {
        return this.diags;
    }

    public double getBadThreshold() {
        return this.bad;
    }

    public double getGoodThreshold() {
        return this.uncertain;
    }

    public boolean isValid() {
        return this.diags != null;
    }

    public String getName() {
        return "Seats";
    }

    public List<String> getTests() {
        return SeatsDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        if (this.diags == null) {
            return ProcQuality.Undefined;
        }
        double pval = this.getValue(test);
        if (Double.isNaN(pval)) {
            return ProcQuality.Undefined;
        }
        if (pval <= this.bad) {
            return ProcQuality.Bad;
        }
        if (pval > this.uncertain) {
            return ProcQuality.Good;
        }
        return ProcQuality.Uncertain;
    }

    public double getValue(String test) {
        double val = Double.NaN;
        int icmp = -1;
        int jcmp = -1;
        if (test.equals("seas variance") || test.equals("seas/irr cross-correlation")) {
            icmp = 2;
        }
        if (test.equals("irregular variance") || test.equals("seas/irr cross-correlation")) {
            jcmp = 3;
        }
        if (test.equals("seas variance")) {
            val = this.diags.getPValue(icmp);
        } else if (test.equals("irregular variance")) {
            val = this.diags.getPValue(jcmp);
        } else if (icmp >= 0 && jcmp >= 0) {
            val = this.diags.getPValue(icmp, jcmp);
        }
        return val;
    }

    public List<String> getWarnings() {
        if (!this.same) {
            return Collections.singletonList("Non decomposable model. Changed by Seats");
        }
        if (this.cutoff) {
            return Collections.singletonList("Parameters cut off by Seats");
        }
        return Collections.emptyList();
    }
}

