# This file was generated by the {rix} R package v0.18.1 on 2026-01-25
# with following call:
# >rix(date = "2026-01-14",
#  > git_pkgs = list(list(package_name = "rix",
#  > repo_url = "https://github.com/ropensci/rix/",
#  > commit = "befd1ad879bc634b93591e3ff3c9ac09a9cd4471"),
#  > list(package_name = "rixpress",
#  > repo_url = "https://github.com/b-rodrigues/rixpress/",
#  > commit = "5b49ed87393de8b82e8e2517665aeab6329666db")),
#  > ide = "none",
#  > project_path = "inst/extdata",
#  > overwrite = TRUE,
#  > r_ver = "4.5.2")
# It uses the `rstats-on-nix` fork of `nixpkgs` which provides improved
# compatibility with older R versions and R packages for Linux/WSL and
# Apple Silicon computers.
# Report any issues to https://github.com/ropensci/rix
let
 pkgs = import (fetchTarball "https://github.com/rstats-on-nix/nixpkgs/archive/2026-01-14.tar.gz") {};
  
    rix = (pkgs.rPackages.buildRPackage {
      name = "rix";
      src = pkgs.fetchgit {
        url = "https://github.com/ropensci/rix/";
        rev = "befd1ad879bc634b93591e3ff3c9ac09a9cd4471";
        sha256 = "sha256-P+RT2FIQ5IHaL1spHNuzRHUcZaYa8qcp9zMs2Gu3ZvU=";
      };
      propagatedBuildInputs = builtins.attrValues {
        inherit (pkgs.rPackages) 
          codetools
          curl
          jsonlite
          sys;
      };
    });

    rixpress = (pkgs.rPackages.buildRPackage {
      name = "rixpress";
      src = pkgs.fetchgit {
        url = "https://github.com/b-rodrigues/rixpress/";
        rev = "5b49ed87393de8b82e8e2517665aeab6329666db";
        sha256 = "sha256-zQ17hz19F7vlDuBvtHfA/NQA4B2GNOG/6SjBQaR7SXs=";
      };
      propagatedBuildInputs = builtins.attrValues {
        inherit (pkgs.rPackages) 
          igraph
          jsonlite
          processx;
      };
    });
      
  system_packages = builtins.attrValues {
    inherit (pkgs) 
      glibcLocales
      nix
      R;
  };
  
  shell = pkgs.mkShell {
    LOCALE_ARCHIVE = if pkgs.stdenv.hostPlatform.system == "x86_64-linux" then "${pkgs.glibcLocales}/lib/locale/locale-archive" else "";
    LANG = "en_US.UTF-8";
    LC_ALL = "en_US.UTF-8";
    LC_TIME = "en_US.UTF-8";
    LC_MONETARY = "en_US.UTF-8";
    LC_PAPER = "en_US.UTF-8";
    LC_MEASUREMENT = "en_US.UTF-8";
    
    buildInputs = [ rix rixpress system_packages ];
    
  }; 
in
  {
    inherit pkgs shell;
  }
