## -----------------------------------------------------------------------------
set.seed(123910) # arbitrary seed 
library(systemicrisk)

## -----------------------------------------------------------------------------
l <- c(1,2.5,3)
a <- c(0.7,2.7,3.1)

## -----------------------------------------------------------------------------
L <- sample_ERE(l,a,p=0.5,lambda=0.25,nsamples=200,thin=20,burnin=10)

## -----------------------------------------------------------------------------
L[[1]]
L[[2]]
L[[3]]

## ----fig.width=7,fig.height=4-------------------------------------------------
plot(sapply(L,function(x)x[1,2]),type="b")

## ----fig.width=7,fig.height=4-------------------------------------------------
acf(sapply(L,function(x)x[1,2]))

## -----------------------------------------------------------------------------
ea <- c(1,1,1)
el <- c(1,1,1)

## -----------------------------------------------------------------------------
default(L[[1]],ea=ea,el=el)$defaultind
default(L[[2]],ea=ea,el=el)$defaultind
default(L[[3]],ea=ea,el=el)$defaultind

## -----------------------------------------------------------------------------
rowMeans(sapply(L, function(Lakt) default(Lakt,ea=ea,el=el)$defaultind))

## -----------------------------------------------------------------------------
rowMeans(sapply(L, function(Lakt) default(Lakt,ea=ea,el=el,alpha=0.98,beta=0.98)$defaultind))

