/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import java.util.logging.Logger;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class TallyHistogram
extends Tally {
    private int[] co;
    private int numBins;
    private double m_h;
    private double m_a;
    private double m_b;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat");

    public TallyHistogram(double a, double b, int s) {
        this.init(a, b, s);
    }

    public TallyHistogram(String name, double a, double b, int s) {
        super(name);
        this.init(a, b, s);
    }

    public void init(double a, double b, int s) {
        super.init();
        if (b <= a) {
            throw new IllegalArgumentException("   b <= a");
        }
        this.co = new int[s + 2];
        this.numBins = s;
        this.m_h = (b - a) / (double)s;
        this.m_a = a;
        this.m_b = b;
        for (int i = 0; i <= s + 1; ++i) {
            this.co[i] = 0;
        }
    }

    public void add(double x) {
        super.add(x);
        if (x < this.m_a) {
            this.co[0] = this.co[0] + 1;
        } else if (x > this.m_b) {
            int n = 1 + this.numBins;
            this.co[n] = this.co[n] + 1;
        } else {
            int i;
            int n = i = 1 + (int)((x - this.m_a) / this.m_h);
            this.co[n] = this.co[n] + 1;
        }
    }

    public int[] getCounters() {
        return this.co;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public double getA() {
        return this.m_a;
    }

    public double getB() {
        return this.m_b;
    }

    public TallyHistogram clone() {
        TallyHistogram image = (TallyHistogram)super.clone();
        int[] coco = new int[2 + this.numBins];
        System.arraycopy(this.co, 0, coco, 0, 2 + this.numBins);
        image.co = coco;
        image.m_h = this.m_h;
        image.m_a = this.m_a;
        image.m_b = this.m_b;
        image.numBins = this.numBins;
        return image;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("---------------------------------------" + PrintfFormat.NEWLINE);
        sb.append(this.name + PrintfFormat.NEWLINE);
        sb.append("Interval = [ " + this.m_a + ", " + this.m_b + " ]" + PrintfFormat.NEWLINE);
        sb.append("Number of bins = " + this.numBins + " + 2" + PrintfFormat.NEWLINE);
        sb.append(PrintfFormat.NEWLINE + "Counters = {" + PrintfFormat.NEWLINE);
        sb.append("   (-inf, " + PrintfFormat.f(6, 3, this.m_a) + ")    " + this.co[0] + PrintfFormat.NEWLINE);
        for (int i = 1; i <= this.numBins; ++i) {
            double a = this.m_a + (double)(i - 1) * this.m_h;
            double b = this.m_a + (double)i * this.m_h;
            sb.append("   (" + PrintfFormat.f(6, 3, a) + ", " + PrintfFormat.f(6, 3, b) + ")    " + this.co[i] + PrintfFormat.NEWLINE);
        }
        sb.append("   (" + PrintfFormat.f(6, 3, this.m_b) + ", inf)    " + this.co[this.numBins + 1] + PrintfFormat.NEWLINE);
        sb.append("}" + PrintfFormat.NEWLINE);
        return sb.toString();
    }
}

