## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
opt <- options()
options(continue="  ", width=70, prompt=" ")
on.exit(options(opt))
library(contTimeCausal, quietly=TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  ctSFTM(data, base = NULL, td = NULL)

## ----eval=FALSE---------------------------------------------------------------
#  ctCoxMSM(data, base = NULL, td = NULL)

## ----eval=FALSE---------------------------------------------------------------
#  print(x, ...)

## -----------------------------------------------------------------------------
data(ctcData)

## -----------------------------------------------------------------------------
head(ctcData)

## -----------------------------------------------------------------------------
ti <- ctcData[,c(5L:9L)]
ti <- ti %>% distinct()

## -----------------------------------------------------------------------------
td <- ctcData[,2L:4L]

## -----------------------------------------------------------------------------
summary(object = ti)

## -----------------------------------------------------------------------------
summary(object = ti$V[ti$deltaV==1L])

## -----------------------------------------------------------------------------
summary(object = td)

## ----echo=TRUE----------------------------------------------------------------
res <- ctSFTM(data = ctcData, base = "x", td = "xt")

## -----------------------------------------------------------------------------
res

## ----echo=TRUE----------------------------------------------------------------
ctSFTM(data = ctcData, base = "x")

## ----echo=TRUE----------------------------------------------------------------
ctSFTM(data = ctcData, td = "xt")

## ----echo=TRUE----------------------------------------------------------------
res <- ctCoxMSM(data = ctcData, base = "x", td = "xt")

## -----------------------------------------------------------------------------
res

## ----echo=TRUE----------------------------------------------------------------
ctCoxMSM(data = ctcData, base = "x")

## ----echo=TRUE----------------------------------------------------------------
ctCoxMSM(data = ctcData, td = "xt")

