% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\docType{data}
\name{swimmers}
\alias{swimmers}
\title{Data from the young elite swimmers study}
\format{
This is a data.table object containing 27 variables and 130 rows
\itemize{
\item \code{period}: Factor. Time periods from two competitions.
\item \code{subject}: Factor. Subject ID.
\item \code{sex}: Factor. Subject's sex (Male of Female).
\item \code{age}: Numeric. Subject's age in years.
\item \code{weight}: Numeric. Weight in kilograms.
\item \code{height}: Numeric. Heigh in centimeters.
\item \code{fat}: Numeric. Body fat in percentage.
\item \code{bmi}: Numeric. Body mass index.
\item \code{ffmi}: Numeric. Fat free mass index.
\item \code{sp}: Numeric. Systolic blood pressure in mmHg.
\item \code{dp}: Numeric. Diastolic blood pressure in mmHg.
\item \code{map}: Numeric. Mean arterial pressure in mmHg.
\item \code{pp}: Numeric. Pulse pressure in mmHg.
\item \code{sdnn_pre}: Numeric. SDNN (Time domain parameter) pre-wingate test.
\item \code{rmssd_pre}: Numeric. RMSSD (Time domain parameter) pre-wingate test.
\item \code{vlf_pre}: Numeric. VLF (Frequency domain parameter) pre-wingate test.
\item \code{lf_pre}: Numeric. LF (Frequency domain parameter) pre-wingate test.
\item \code{hf_pre}: Numeric. HF (Frequency domain parameter) pre-wingate test.
\item \code{sdnn_post}: Numeric. SDNN (Time domain parameter) post-wingate test.
\item \code{rmssd_post}: Numeric. RMSSD (Time domain parameter) post-wingate test.
\item \code{vlf_post}: Numeric. VLF (Frequency domain parameter) post-wingate test.
\item \code{lf_post}: Numeric. LF (Frequency domain parameter) post-wingate test.
\item \code{hf_post}: Numeric. HF (Frequency domain parameter) post-wingate test.
\item \code{power_peak}: Numeric. Peak power output in Watts.
\item \code{power_mean}: Numeric. Mean power output in Watts.
\item \code{power_min}: Numeric. Minimum power output in Watts.
\item \code{fatigue}: Numeric. Fatigue index in percentage.
}
}
\source{
\doi{10.3389/fphys.2021.769085}
}
\usage{
swimmers
}
\description{
This is the data used for the young elite swimmers
study (Castillo-Aguilar et al. 2021). It contains records from
26 competitive swimmers from ages 10 to 16 on 5 different
competitive time periods.
}
\keyword{datasets}
