% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xxhash.R
\name{xxhash}
\alias{xxhash}
\title{Calculate the hash of an arbitrary R object.}
\usage{
xxhash(robj, algo = "xxh128", as_raw = FALSE)
}
\arguments{
\item{robj}{Any R object}

\item{algo}{Select the specific xxhash algorithm. Default: 'xxh128'.
(the latest algorithm in the xxhash family)
Valid values: 'xxh32', 'xxh64', 'xxh128', 'xxh3'}

\item{as_raw}{Return the hash as a raw vector of bytes instead of string?
Default: FALSE.  If TRUE, then the raw bytes are returned in big-endian
order - which is what \code{xxHash} considers the \emph{canonical} form.}
}
\value{
String representation of hash. If \code{as_raw = TRUE} then a 
        raw vector is returned instead.
}
\description{
This function will calculate the hash of any object understood by
\code{base::serialize()}.
}
\examples{
xxhash(mtcars)
xxhash(mtcars, algo = 'xxh3', as_raw = TRUE)
}
