% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvim-design-matrix.R
\name{wvim_design_matrix}
\alias{wvim_design_matrix}
\title{Create Feature Selection Design Matrix}
\usage{
wvim_design_matrix(
  all_features,
  feature_names = all_features,
  direction = c("leave-out", "leave-in")
)
}
\arguments{
\item{all_features}{(character()) All available feature names from the task.}

\item{feature_names}{(character() | list of character()) Features or feature
groups to evaluate. Can be a vector for individual features or a named list
for grouped features. Defaults to \code{all_features} if unspecified.}

\item{direction}{(character(1)) Either \code{"leave-in"} or \code{"leave-out"} (default).
Controls which features are selected in the design matrix.
\code{"leave-out"} sets features of interest to \code{FALSE}, and \code{"leave-in"} analogously
sets them to \code{TRUE}.}
}
\value{
data.table with logical columns for each feature in \code{all_features} and
\code{length(feature_names)} rows, one for each entry in \code{feature_names}
}
\description{
Creates a logical design matrix for leave-in or leave-out feature evaluation.
Used internally with mlr3fselect to evaluate feature subsets.
}
\examples{
task = mlr3::tsk("mtcars")

# Individual features
feature_names = task$feature_names[1:3]
wvim_design_matrix(task$feature_names, feature_names, "leave-in")
wvim_design_matrix(task$feature_names, feature_names, "leave-out")

# Feature groups
feature_groups = list(
  A = task$feature_names[1:2],
  B = task$feature_names[3:5]
)
wvim_design_matrix(task$feature_names, feature_groups, "leave-out")

}
