% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Element.R
\docType{class}
\name{Element-class}
\alias{Element-class}
\alias{Element}
\alias{as.vector,Element-method}
\alias{as.character,Element-method}
\title{Element, A reference class representing an XML tag}
\usage{
\S4method{as.vector}{Element}(x)

\S4method{as.character}{Element}(x)
}
\arguments{
\item{x}{the object to convert}
}
\description{
An XML element. Methods allow the user to get and manipulate its child
elements and content, directly access the element's textual content, and
manipulate its attributes.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as.vector}: as.vector(Element)

\item \code{as.character}: as.character(Element)
}}

\section{Fields}{

\describe{
\item{\code{name}}{The local name of the element}

\item{\code{contentList}}{all the children of this element}

\item{\code{attributeList}}{a list of all the attributes belonging to this element}
}}

\section{Methods}{

\describe{
\item{\code{addAttributes(attributes)}}{Add the supplied attributes to the attributeList of this Element}

\item{\code{addContent(content)}}{Appends the child to the end of the content list. return the parent (the calling object)}

\item{\code{contentIndex(content)}}{Find the position of the content in the contentList or -1 if not found}

\item{\code{getAttribute(name)}}{Get an attribute value}

\item{\code{getAttributes()}}{Get the list of attributes}

\item{\code{getChild(name)}}{Return the first child element matching the name}

\item{\code{getChildren()}}{Get all the child Elements belong to this Element}

\item{\code{getContent()}}{Returns the full content of the element as a List that may contain objects of type Text, Element, Comment, ProcessingInstruction, CDATA, and EntityRef}

\item{\code{getName()}}{Return the name of this Element}

\item{\code{getText()}}{Return the text content of this element if any}

\item{\code{hasAttributes()}}{return TRUE if this element has any attributes, otherwise FALSE}

\item{\code{hasChildren()}}{Return TRUE if this element has any child Element nodes}

\item{\code{hasContent()}}{return TRUE if this element has any content, otherwise FALSE}

\item{\code{hasText()}}{Return TRUE if this element has a Text node}

\item{\code{removeContent(content)}}{Remove the specified content from this element}

\item{\code{removeContentAt(index)}}{Remove the content at the given index and return the content that was removed}

\item{\code{setAttribute(name, value)}}{Add or replace an attribute, parameters will be converted to characters}

\item{\code{setAttributes(attributes)}}{Replace the attributes with this named list, NULL or empty list will remove all attributes, all values will be converted to characters}

\item{\code{setName(name)}}{Set the name of this Element}

\item{\code{setText(text)}}{Replace all content with the text supplied}
}}

