% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml2relational.r
\name{getInsertSQL}
\alias{getInsertSQL}
\title{Exporting the relational data model and data to a database}
\usage{
getInsertSQL(
  ldf,
  table.name,
  line.break = "\\n",
  one.statement = FALSE,
  tz = "UTC"
)
}
\arguments{
\item{ldf}{A \strong{l}ist of \strong{d}ata\strong{f}rames created by
\code{\link{toRelational}()} (the data tables transformed from XML to a
relational schema).}

\item{table.name}{Name of the table from the data table list \code{ldf} for
which \code{INSERT} statements are to be created.}

\item{line.break}{Line break character that is added to the end of each
\code{INSERT} statement (apart from the semicolon that is added
automatically). Default is \code{"\n"}.}

\item{one.statement}{Determines whether all \code{INSERT} statements will be
returned as one piece of SQL code (\code{one.statement = TRUE}) or if each
\code{INSERT} statement will be stored in a separate element of the return
vector. In the former case the return vector will have just one element, in
the latter case as many elements as there are data records to insert.
Default is \code{FALSE} (return vector has one element per \code{INSERT}
statement.}

\item{tz}{The code of the timezone used for exporting timestamp data. Default it
\code{"UTC"} (Coordinated Universal Time).}
}
\value{
A character vector with exactly one element (if argument
  \code{one.statement = TRUE}) or with one element per \code{INSERT}
  statement.
}
\description{
Produces ready-to-run SQL \code{INSERT} statements to import the
  data transformed with \code{\link{toRelational}()} into a SQL database.
}
\examples{
# Find path to custmers.xml example file in package directory
path <- system.file("", "customers.xml", package = "xml2relational")
db <- toRelational(path)

sql.code <- getInsertSQL(db, "address")

}
\seealso{
Other xml2relational: 
\code{\link{getCreateSQL}()},
\code{\link{savetofiles}()},
\code{\link{toRelational}()}
}
\concept{xml2relational}
