% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisite_shuffle.R
\name{multisite_shuffle}
\alias{multisite_shuffle}
\title{Multisite shuffling of wxgenR simulation results}
\usage{
multisite_shuffle(list.sta.wx, numbCores = NULL, aseed = NULL)
}
\arguments{
\item{list.sta.wx}{A list containing multiple stations' observed and simulated data to be used in multisite shuffling.
Each list element should be named for the station's data it holds and should contain the dataframe output from the `wx` for that station.}

\item{numbCores}{Enable parallel computing for multisite shuffling,
set number of cores to enable (must be a positive integer greater than or equal to 2).
 Turned off by default; if set to 0 or 1 it will run as single thread.
  Use function 'detectCores()' from 'parallel' package to show the number of available cores on your machine.}

\item{aseed}{Specify a seed for reproducibility.}
}
\value{
Returns a list containing results and metadata from the multisite shuffling in 'long' format for easy analysis and visualization.
\itemize{
  \item shuffledResultsOnly - Dataframe containing shuffled simulations for all traces and stations ('sim_prcp' and 'sim_temp').
  \item shuffledResultsAndObs - Dataframe containing shuffled simulations as well as corresponding observations/training data ('prcp' and 'temp' are the observed data).
  \item shuffledAndUnshuffled - Dataframe containing shuffled simulations, unshuffled simulations, observations. Unshuffled vs and shuffled are indicated by the 'Tag' variable.
}
}
\description{
Runs a postprocessor on `wx` simulation results to shuffle
multiple stations' simulations such that wxgenR can be used in multisite applications.
Specifically, the `multisite_shuffle` function uses an approach developed by Iman and Conover (1982) and later applied by Clark et al. (2004)
to capture the rank correlation among observed station data and introduce it to those stations' simulations. The Iman and Conover approach is implemented
using the `cornode` function from the `mc2d` package.
}
\examples{
\donttest{
# Simulated example with two stations

data(BOCO_sims)

ms = multisite_shuffle(BOCO_sims, numbCores = 2, aseed = 123)

print(ms)
}

}
\references{
Iman, Ronald & Conover, William. (1982). A Distribution-Free Approach to Inducing Rank Correlation Among Input Variates. Communications in Statistics-simulation and Computation - COMMUN STATIST-SIMULAT COMPUT. 11. 311-334. 10.1080/03610918208812265.

Clark, M., Gangopadhyay, S., Hay, L., Rajagopalan, B., & Wilby, R. (2004). The Schaake Shuffle: A Method for Reconstructing Space–Time Variability in Forecasted Precipitation and Temperature Fields. Journal of Hydrometeorology, 5(1), 243-262. https://doi.org/10.1175/1525-7541(2004)005<0243:TSSAMF>2.0.CO;2

R. Pouillot, M.-L. Delignette-Muller (2010), Evaluating variability and uncertainty in microbial quantitative risk assessment using two R packages. International Journal of Food Microbiology. 142(3):330-40
}
