% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds.ratio.R
\name{odds.ratio}
\alias{odds.ratio}
\title{Odds Ratio}
\usage{
odds.ratio(data, y, w.order, which.marker)
}
\arguments{
\item{data}{a data frame or matrix containing genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1), according to minor allele count.}

\item{y}{binary values.}

\item{w.order}{a numeric number taking values 1 or 2. If w.order = 1, odds ratio of main effect is calculated. If w.order = 2, odds ratio of pairwise interaction is calculated.}

\item{which.marker}{a numeric vector, when w.order = 1, a single value indicating the column index of the variable to calculate; when w.order = 2, a vector indicating the column index of a SNP-pair to calculate.}
}
\value{
The odds ratio of a SNP or a SNP-pair.
}
\description{
Calculate odds ratio for a single SNP or a pair of SNPs. Single marker odds ratio is computed by contigency table as the odds of disease at minor allele vs the odds of diseases at major allele. Odds ratio of a pair of SNPs is calculated by the Logistic Regression.
}
\examples{
data(diabetes.geno)
data(phenotype1)
y <- as.numeric(phenotype1)
OR.snp4.snp8 <- odds.ratio(diabetes.geno, y, w.order=2, which.marker = c(4,8))
OR.snp4 <- odds.ratio(diabetes.geno, y, w.order = 1, which.marker = 4)
}
