% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ws_tdiff_multivariate.r
\name{ws_tdiff_multivariate_independent}
\alias{ws_tdiff_multivariate_independent}
\title{Welch-Satterthwaite Approximation for Multivariate t-Differences (Independent)}
\usage{
ws_tdiff_multivariate_independent(mu1, sigma1, nu1, mu2, sigma2, nu2)
}
\arguments{
\item{mu1}{Location vector of first distribution (length p)}

\item{sigma1}{Scale vector of first distribution (length p, all > 0)}

\item{nu1}{Degrees of freedom vector of first distribution (length p, all > 4)}

\item{mu2}{Location vector of second distribution (length p)}

\item{sigma2}{Scale vector of second distribution (length p, all > 0)}

\item{nu2}{Degrees of freedom vector of second distribution (length p, all > 4)}
}
\value{
An S3 object of class "ws_tdiff_multivariate_independent" containing:
  \item{mu_diff}{Location vector of difference}
  \item{sigma_star}{Vector of effective scale parameters}
  \item{nu_star}{Vector of effective degrees of freedom}
  \item{p}{Dimension of the vectors}
  \item{method}{Character string "multivariate_independent"}
}
\description{
Approximates the distribution of differences between two independent
p-dimensional vectors with independent t-distributed components.
}
\details{
This function applies the univariate Welch-Satterthwaite approximation
component-wise when all components are mutually independent. Each
component difference Zj = X1j - X2j is approximated independently using
the univariate method.

This approach is optimal for:
\itemize{
  \item Marginal inference on specific components
  \item Cases where components have different tail behaviors
  \item Maintaining computational efficiency in high dimensions
}
}
\examples{
result <- ws_tdiff_multivariate_independent(
  mu1 = c(0, 1), sigma1 = c(1, 1.5), nu1 = c(10, 12),
  mu2 = c(0, 0), sigma2 = c(1.2, 1), nu2 = c(15, 20)
)
print(result)

}
\seealso{
\code{\link{ws_tdiff_multivariate_general}} for correlated components
}
