% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{remove_endpoint}
\alias{remove_endpoint}
\title{Remove endpoint from WORCS project}
\usage{
remove_endpoint(filename = NULL, worcs_directory = ".", verbose = TRUE, ...)
}
\arguments{
\item{filename}{Character, indicating the file to be removed from the
endpoints.
Default: NULL.}

\item{worcs_directory}{Character, indicating the WORCS project directory
to which to save data. The default value "." points to the current directory.
Default: '.'}

\item{verbose}{Logical. Whether or not to print status messages to the
console. Default: TRUE}

\item{...}{Additional arguments.}
}
\value{
None, prints to the console.
}
\description{
Remove an endpoint from a WORCS project.
}
\examples{
if(requireNamespace("withr", quietly = TRUE)){
 withr::with_tempdir({
   file.create(".worcs")
   write.csv(iris, "iris.csv")
   add_endpoint("iris.csv")
   list_endpoints()
   remove_endpoint("iris.csv")
   list_endpoints()
 })
}
}
\seealso{
\code{\link[worcs]{add_endpoint}}
\code{\link[worcs]{snapshot_endpoints}}
}
