% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_document}
\alias{whapi_send_document}
\title{Send a DOCUMENT via Whapi.Cloud (file, url, or base64)}
\usage{
whapi_send_document(
  to,
  document,
  type = c("file", "url", "base64"),
  caption = NULL,
  filename = NULL,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character(1). WhatsApp target (E.164 digits only, no "+") or chat id.}

\item{document}{Character(1). File path (when \code{type="file"}), URL (\code{"url"}), or data URI (\code{"base64"}).}

\item{type}{One of \code{c("file","url","base64")}. Default: \code{"file"}.}

\item{caption}{Optional caption text.}

\item{filename}{Optional filename shown to the user. If omitted:
\itemize{
\item \code{type="file"}   -> uses \code{basename(document)};
\item \code{type="url"}    -> uses the URL basename (without query/fragment);
\item \code{type="base64"} -> tries the \verb{name=} part inside the data URI.
}}

\item{token}{Bearer token (defaults to env var \code{WHAPI_TOKEN}).}

\item{timeout}{Numeric. Request timeout in seconds. Default \code{30}.}

\item{verbose}{Logical. Print CLI messages? Default \code{TRUE}.}
}
\value{
A tibble with \code{id}, \code{to}, \code{status}, \code{timestamp}, \code{timestamp_dt}, and raw \code{resp}.
}
\description{
Sends a document using Whapi's \code{POST /messages/document}.
Supports three input modes via \code{type}:
\itemize{
\item \code{"file"}   : local path -> reads bytes and builds a data URI
(\verb{data:<mime>;name=<file>;base64,<...>});
\item \code{"url"}    : direct \code{http(s)} URL;
\item \code{"base64"} : pre-built data URI (\verb{data:application/...;name=...;base64,...}).
}
}
\examples{
\dontrun{
 Sys.setenv(WHAPI_TOKEN = "your_token_here")
 whapi_send_document("5581999999999", "report.pdf", type="file", caption="Monthly report")
 whapi_send_document("5581999999999", "https://example.com/contract.docx", type="url")
 b <- openssl::base64_encode(readBin("memo.odt","raw",file.info("memo.odt")$size))
 du <- sprintf("data:application/vnd.oasis.opendocument.text;name=\%s;base64,\%s",
  basename("memo.odt"), b)
 whapi_send_document("5581999999999", du, type="base64")
}
}
