% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_coerce_buttons_base}
\alias{whapi_coerce_buttons_base}
\title{Coerce and normalize button specs for Whapi interactive messages}
\usage{
whapi_coerce_buttons_base(buttons, verbose = TRUE)
}
\arguments{
\item{buttons}{A \code{data.frame}/\code{tibble} with columns per button (e.g.
\code{title}, \code{id}, etc.) \strong{or} a list of named lists. Can be \code{NULL}
(returns empty list).}

\item{verbose}{Logical (default \code{TRUE}). If \code{TRUE}, prints progress messages
via \pkg{cli} (how many buttons, how many ids auto-generated, etc.).}
}
\value{
A \strong{list of named lists} (one per button), each guaranteed to have
at least \code{title} (non-empty). If a button had no \code{id}, a slugified,
unique \code{id} is created.
}
\description{
Internal helper that converts a \code{data.frame}/\code{tibble} or \code{list} of button
definitions into a normalized \strong{list-of-lists}, applying a few rules:
\itemize{
\item Accepts aliases \code{label} / \code{name} and maps them to \code{title};
\item Requires a non-empty \code{title};
\item Auto-generates \code{id} when missing using slugification plus uniqueness
enforcement (e.g., \code{"Buy Now" -> "buy_now"}, duplicates become
\code{"buy_now_2"}, \code{"buy_now_3"}, ...).
}

This is useful before building payloads for Whapi interactive endpoints
(e.g., buttons, mixed actions, etc.).
}
\examples{
# From tibble (title only -> ids auto-generated)
 tibble::tribble(~title, "Buy Now", "Buy Now", "Learn More") |>
   whapi_coerce_buttons_base()

# From list (mix with/without id)
 whapi_coerce_buttons_base(list(
   list(title = "Website", url = "https://example.com"),
   list(title = "Website")  # will get an auto id too
 ))

}
\seealso{
\code{whapi_slugify()}, \code{whapi_make_unique()}
}
