% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_common_columns.R
\name{find_common_columns}
\alias{find_common_columns}
\title{Find Common Columns Between Data Frames}
\usage{
find_common_columns(...)
}
\arguments{
\item{...}{A variable length list of data frames.}
}
\value{
A character vector of column names found in common between all data frames.
}
\description{
This function identifies common column names between multiple data frames.
It takes a variable number of data frames as input and returns a character
vector containing the common column names.
}
\examples{
df1 <- data.frame(a = c(1, 2, 3), b = c(4, 5, 6))
df2 <- data.frame(a = c(7, 8, 9), b = c(10, 11, 12), c = c(13, 14, 15))
common_columns <- find_common_columns(df1, df2)
print(common_columns)

}
