% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vst_dct_fcts.R
\name{Toep.estimator}
\alias{Toep.estimator}
\title{Toeplitz Covariance and Precision Matrix Estimator}
\usage{
Toep.estimator(y, Te, q, method, f.true = NULL)
}
\arguments{
\item{y}{\code{nxp}  dimensional data matrix}

\item{Te}{number of bins for data binning.}

\item{q}{penalization order, \code{q=1,2,3,4} are available}

\item{method}{to select the smoothing parameter of the smoothing spline. Available methods are restricted maxmimum likelihodd "\code{ML}", generalized cross-validation "\code{GCV}" and the oracle versions "\code{ML-oracle}", "\code{GCV-oracle}".}

\item{f.true}{Te-dimensional vector with the true spectral density function evaluated at equi-sapced points in [0,\code{pi}]. Only required, if an oracle method ("\code{ML-oracle}", "\code{GCV-oracle}") is chosen for \code{method}.}
}
\value{
A list containing the following elements:
\itemize{
\item{\code{toep}:   }{\code{p}-dim. Toeplitz covariance matrix}
\item{\code{toep.inv}:  }{\code{p}-dim. precision matrix}
\item{\code{acf}:  }{\code{p}-dim. vector with the covariance function}
\item{\code{sdf}:  }{\code{p}-dim. vector with the spectral density in the interval [0,1]}
}
}
\description{
Estimates the Toeplitz covariance matrix, the inverse matrix and the spectral density from a sample of \code{n} i.i.d. \code{p}-dimensional vectors with mean zero.
}
\examples{
#EXAMPLE 1: Simulate Gaussian ARMA(2,2)
library(nlme)
library(MASS)
p=100
n=1
Sigma=1.44*corMatrix(Initialize(corARMA(c(0.7, -0.4,-0.2, 0.2),p=2,q=2),data=diag(1:p)))
Y=matrix(mvrnorm(n, mu=numeric(p), Sigma=Sigma),n,p)
fit.toep=Toep.estimator(y=Y,Te=10,q=2,method="GCV")$toep


#EXAMPLE 2: AQUAPORIN DATA
data(aquaporin)
n=length(aquaporin$Y)
y.train=aquaporin$Y[1:(0.01*n)]
y.train=y.train-mean(y.train)
fit.toep=Toep.estimator(y=y.train,Te=10,q=1,method="ML")$toep
}
