% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vse.R
\name{Wnoise.test}
\alias{Wnoise.test}
\title{Testing White Noise in Time Series}
\usage{
Wnoise.test(x, m = 0.5, n = NULL)
}
\arguments{
\item{x}{A time series vector.}

\item{m}{A parameter to control the number of scales. Default is 0.5.}

\item{n}{The number of scales. If \code{NULL}, it will be calculated as \code{floor(N^m)}.}
}
\value{
A list with class "Wnoise.test" containing the following components:
\item{Wnoise}{the test statistic }
\item{df}{the degrees of freedom of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
The function Wnoise.test computes the test statistic for white noise in time series based on the variance scale exponent.
The null hypothesis is that the time series is independent white noise, while the alternative hypothesis is that the time series is a non-independent stochastic process.
}
\examples{
## Test white noise in time series
library(pracma)

set.seed(123)
data("brown72")
x72 <- brown72                          #  H = 0.72
xgn <- rnorm(1024)                      #  H = 0.50
xlm <- numeric(1024); xlm[1] <- 0.1     #  H = 0.43
for (i in 2:1024) xlm[i] <- 4 * xlm[i-1] * (1 - xlm[i-1])

Wnoise.test(x72)
Wnoise.test(xgn)
Wnoise.test(xlm)

}
\references{
Fu, H., Chen, W., & He, X.-J. (2018). On a class of estimation and test for long memory. In Physica A: Statistical Mechanics and its Applications (Vol. 509, pp. 906–920). Elsevier BV. https://doi.org/10.1016/j.physa.2018.06.092
}
