% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/election_get_election_by_year_state.R
\name{election_get_election_by_year_state}
\alias{election_get_election_by_year_state}
\title{Get election info by election year and state}
\usage{
election_get_election_by_year_state(
  years = lubridate::year(lubridate::today()),
  state_ids = "",
  all = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{years}{A vector of election years.}

\item{state_ids}{A vector of state abbreviations.}

\item{all}{Boolean: should all possible combinations of the variables be searched for, or just the exact combination of them in the order they are supplied?}

\item{verbose}{Should cases when no data is available be messaged?}
}
\value{
A dataframe of candidates and their attributes. If a given \code{year} + \code{state_id} returns no data, that row will be filled with \code{NA}s.
}
\description{
Get election info by election year and state
}
\examples{
\dontrun{
election_get_election_by_year_state(years = c(2016, 2017))
}
}
