% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_counts_items_grouped_items}
\alias{plot_counts_items_grouped_items}
\title{Correlation of categorical items with categorical items}
\usage{
plot_counts_items_grouped_items(
  data,
  cols,
  cross,
  method = "cramer",
  numbers = TRUE,
  category = NULL,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{cross}{Tidyselect item variables (e.g. starts_with...).}

\item{method}{The method of correlation calculation:
\itemize{
\item \code{cramer} for Cramer's V,
\item \code{npmi} for Normalized Pointwise Mutual Information.
}}

\item{numbers}{Whether to print the association values on the tiles. Default is \code{TRUE}.}

\item{category}{The value FALSE will force to plot all categories.
A character value will focus a selected category.
When NULL, in case of boolean values, only the TRUE category is plotted.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_counts}.}
}
\value{
A ggplot object.
}
\description{
Correlation of categorical items with categorical items
}
\examples{
library(volker)
data <- volker::chatgpt

plot_counts_items_grouped_items(
  data,
  starts_with("cg_adoption_advantage"),
  starts_with("cg_adoption_fearofuse"),
  method = "cramer"
)

}
\keyword{internal}
