% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/village_state.R
\docType{class}
\name{village_state}
\alias{village_state}
\title{village_state}
\description{
This is an object that represents the state of a village at a particular time.
}
\details{
This class acts as a type of record that holds the values of the different village variables. This class
can be subclassed to include more variables that aren't present.
}
\section{Methods}{



\describe{
}
Creates a new State
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{step}}{The time step that the state is relevant to}

\item{\code{agent_states}}{A list of agent states}

\item{\code{resource_states}}{A list of resource states}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-village_state-new}{\code{village_state$new()}}
\item \href{#method-village_state-clone}{\code{village_state$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-village_state-new"></a>}}
\if{latex}{\out{\hypertarget{method-village_state-new}{}}}
\subsection{Method \code{new()}}{
Initializes all of the properties in the state to the ones passed in. This should
be called by subclasses during initialization.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{village_state$new(
  step = 0,
  agent_states = vector(),
  resource_states = vector()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step}}{The time step that the state is relevant to}

\item{\code{agent_states}}{A vector of tibbles representing the states of the agents}

\item{\code{resource_states}}{A vector of tibbles representing the states of the resources}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When adding a new property, make sure to add it to the tibble
representation.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-village_state-clone"></a>}}
\if{latex}{\out{\hypertarget{method-village_state-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{village_state$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
