% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb_meddra.R
\name{tb_meddra}
\alias{tb_meddra}
\title{Create MedDRA tables}
\usage{
tb_meddra(path_meddra)
}
\arguments{
\item{path_meddra}{Character string, a directory containing MedDRA ascii tables.
It is also the output directory.}
}
\value{
.parquet files into the \code{path_meddra} directory.
Three tables: \code{meddra_hierarchy}, \code{smq_list}, and \code{smq_content}.
Some columns are returned as \code{integer} (all \verb{*_code} columns).
All other columns are \code{character}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Transform MedDRA .ascii
files to .parquet files

MedDRA is delivered as ascii files, that you should
transform to a more efficient format. Parquet format from arrow has many advantages:
It works with out-of-memory data, which makes it possible to process tables on
a computer with not-so-much RAM. It is also lightweighted and standard across different
langages.
The function also creates variables in each table.
You should note that NOT all MedDRA tables are processed with this function.
Three tables are created: \code{meddra_hierarchy}, that respects the System Organ
Class hierarchic classification. \code{smq_list} and \code{smq_content} for Standardized
MedDRA Queries.
\strong{Caution} There tends to be small variations in the MedDRA ascii files structure.
Last verified version on which this function is working is \strong{26.1}.
Use \code{\link[=dt_parquet]{dt_parquet()}} to load the tables afterward.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}

# Use the examples from tb_main if you want to see these functions in action.

path_meddra <- paste0(tempdir(), "/meddra_directory/")
dir.create(path_meddra)
create_ex_meddra_asc(path_meddra)

tb_meddra(path_meddra = path_meddra)

# Clear temporary files when you're done
unlink(path_meddra, recursive = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tb_vigibase]{tb_vigibase()}}, \code{\link[=tb_who]{tb_who()}}, \code{\link[=tb_subset]{tb_subset()}}, \code{\link[=dt_parquet]{dt_parquet()}}
}
\keyword{import}
\keyword{meddra}
