% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progression_sources.r
\name{progression.schell2014}
\alias{progression.schell2014}
\title{Schell 2014 VF progression}
\usage{
progression.schell2014(measmatrix)
}
\arguments{
\item{measmatrix}{is a data frame. MUST contain the following columns: 'md' (mean deviation) and 'eyeid'. Rows represent the single measurements. The minimum measurements (rows) is 4.}
}
\value{
"stable", "worsening", or "improving" of measurements in \code{measmatrix}.  Note: If a VF series is temporarily improving and temporarily worsening, it is assumed to be "stable" overall
}
\description{
\code{progression.schell2014} returns the progression criterion after Schell et al. 2014, which is essentially like CIGTS but with MD, and only one follow-up is enough to confirm progression.
}
\examples{
data(vf.schell2014)
colnames(vf.schell2014)
progression.schell2014(vf.schell2014)
progression.schell2014(vf.schell2014[vf.schell2014$eyeid == 1,])
progression.schell2014(vf.schell2014[vf.schell2014$eyeid == 2,])
}
\seealso{
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4495761/}
}
