% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromspec.r
\encoding{UTF-8}
\name{to_spec}
\alias{to_spec}
\title{Convert a spec created with widget idioms to JSON}
\usage{
to_spec(vl, pretty = TRUE, to_cb = FALSE)
}
\arguments{
\item{vl}{a Vega-Lite object}

\item{pretty}{if \code{TRUE} (default) then a "pretty-printed" version of the spec
will be returned. Use \code{FALSE} for a more compact version.}

\item{to_cb}{if \code{TRUE}, will copy the spec to the system clipboard. Default is \code{FALSE}.}
}
\value{
JSON spec
}
\description{
Takes an htmlwidget object and turns it into a JSON Vega-Lite spec
}
\examples{
dat <- jsonlite::fromJSON('[
    {"a": "A","b": 28}, {"a": "B","b": 55}, {"a": "C","b": 43},
    {"a": "D","b": 91}, {"a": "E","b": 81}, {"a": "F","b": 53},
    {"a": "G","b": 19}, {"a": "H","b": 87}, {"a": "I","b": 52}
  ]')

vegalite() \%>\%
  add_data(dat) \%>\%
  encode_x("a", "ordinal") \%>\%
  encode_y("b", "quantitative") \%>\%
  mark_bar() -> chart

to_spec(chart)
}

