% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.r
\encoding{UTF-8}
\name{scale_y_quantile}
\alias{scale_y_quantile}
\title{Quantile Scale}
\usage{
scale_y_quantile(vl, domain = NULL, range = NULL, clamp = NULL,
  nice = NULL, zero = NULL)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{domain}{Custom domain values. For quantitative data, this can take the
form of a two-element array with minimum and maximum values.}

\item{range}{The range of the scale represents the set of output visual values.
Vega-Lite automatically determines appropriate range based on the scale’s
channel and type, but range property can be provided to customize range
values.}

\item{clamp}{if true, values that exceed the data domain are clamped to either
the minimum or maximum range value. Default value: derived from scale
config (true by default) Supported Types: only linear, pow, sqrt, and log}

\item{nice}{If true, modifies the scale domain to use a more human-friendly
number range (e.g., 7 instead of 6.96). Default value: true only for
quantitative x and y scales and false otherwise.}

\item{zero}{If true, ensures that a zero baseline value is included in the
scale domain. Default value: true if the quantitative field is not binned.}
}
\description{
Quantile Scale
}
\references{
\href{http://vega.github.io/vega-lite/docs/scale.html}{Vega-Lite Scales spec}
}

