% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.r
\encoding{UTF-8}
\name{mark_tick}
\alias{mark_tick}
\title{Tick mark}
\usage{
mark_tick(vl, orient = NULL, size = NULL, thickness = 1, opacity = NULL,
  color = NULL, fill = NULL, stroke = NULL)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{orient}{the orientation of a non-stacked bar, area, and line charts.
The value is either "horizontal", or "vertical" (default). For bar and
tick, this determines whether the size of the bar and tick should be
applied to x or y dimension. For area, this property determines the
orient property of the Vega output. For line, this property determines
the path order of the points in the line if path channel is not specified.
For stacked charts, this is always determined by the orientation of the stack;
therefore explicitly specified value will be ignored.}

\item{size}{The pixel area each the point. For example: in the case of circles,
the radius is determined in part by the square root of the size value.}

\item{thickness}{Thickness of the tick mark. Default value: 1}

\item{opacity}{\code{0.0}-\code{1.0}}

\item{color}{color of the mark – either fill or stroke color based on the filled mark config.}

\item{fill}{fill color. This config will be overridden by color channel’s
specified or mapped values if filled is true.}

\item{stroke}{stroke color. This config will be overridden by color channel’s
specified or mapped values if filled is false.}
}
\description{
A tick mark represents each data point as a short line. This is a useful
mark for displaying the distribution of values in a field.
}
\examples{
vegalite() \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/cars.json") \%>\%
  encode_x("Horsepower", "quantitative") \%>\%
  encode_y("Cylinders", "ordinal") \%>\%
  mark_tick()
}
\references{
\href{http://vega.github.io/vega-lite/docs/mark.html}{Vega-Lite Mark spec}
}

