% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.group.R
\name{cov.group}
\alias{cov.group}
\title{Group covariance matrices}
\usage{
cov.group(X, groups, sex = NULL, use = "everything")
}
\arguments{
\item{X}{a data matrix with variables in columns and group names as row names}

\item{groups}{a character / factor vector containing grouping variable}

\item{sex}{NULL (default). A character / factor vector containing sex variable,
to remove sexual dimorphism by averaging males and females in each group}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values.
This must be (an abbreviation of) one of the strings "everything", "all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs".}
}
\value{
A (p x p x m) array of covariance matrices,
where p is the number of variables and m the number of groups.
}
\description{
Computes the covariance matrix of each group.
The effect of sexual dimorphism can be removed by using, for each group,
the average of the covariance matrix of males and the covariance matrix of females.
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus.IK.coord")
coords <- which(names(Tropheus.IK.coord) == "X1"):which(names(Tropheus.IK.coord) == "Y19")
proc.coord <- as.matrix(Tropheus.IK.coord[coords])

# Covariance matrix of each population
S.phen.pop <- cov.group(proc.coord, groups = Tropheus.IK.coord$POP.ID)

# Covariance matrix of each population, pooled by sex
S.phen.pooled <- cov.group(proc.coord,
groups = Tropheus.IK.coord$POP.ID, sex = Tropheus.IK.coord$Sex)

}
\seealso{
\code{\link[stats:cor]{cov}} and \code{\link[base]{scale}}
}
