% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs_tooltip}
\alias{v_specs_tooltip}
\title{Set tooltip options}
\usage{
v_specs_tooltip(vc, ..., .reset = FALSE)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{...}{Options for the tooltip, see examples or
\href{https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Tooltip}{online documentation}.}

\item{.reset}{Reset previous tooltip configuration before updating.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Set tooltip options
}
\examples{
library(vchartr)
data("mpg", package = "ggplot2")

vchart(table(Class = mpg$class, Year = mpg$year)) \%>\%
  v_bar(aes(Class, Freq, fill = Year)) \%>\%
  v_specs_tooltip(
    visible = FALSE
  )
}
