% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_gen.R
\name{sample_gen}
\alias{sample_gen}
\title{Generate random samples.}
\usage{
sample_gen(L, n)
}
\arguments{
\item{L}{p-dimensional inverse Cholesky factor of true covariance matrix.}

\item{n}{number of samples to generate.}
}
\value{
returns a n-by-p matrix with each row a random sample generated.
}
\description{
Generate \code{n} random samples from multivariate Gaussian distribution N(0, (L^TL)^{-1})
}
\examples{
set.seed(123)
true <- varband_gen(p = 50, block = 5)
x <- sample_gen(L = true, n = 100)
}

