% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ba_methods.R
\name{summary.ba_analysis}
\alias{summary.ba_analysis}
\title{Summary method for ba_analysis objects}
\usage{
\method{summary}{ba_analysis}(object, ...)
}
\arguments{
\item{object}{An object of class \code{ba_analysis}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{summary.ba_analysis} containing:
\describe{
\item{call}{The original function call.}
\item{n}{Number of paired observations.}
\item{n_excluded}{Number of pairs excluded due to NAs.}
\item{var_names}{Variable names for x and y.}
\item{type}{Type of difference calculation.}
\item{conf_level}{Confidence level used.}
\item{descriptives}{Data frame with descriptive statistics.}
\item{agreement}{Data frame with agreement statistics.}
\item{normality_test}{Shapiro-Wilk test result for differences.}
}
}
\description{
Provides a detailed summary of Bland-Altman analysis results, including
additional diagnostics and descriptive statistics.
}
\examples{
set.seed(42)
method_a <- rnorm(50, mean = 100, sd = 15)
method_b <- method_a + rnorm(50, mean = 2, sd = 5)
ba <- ba_analysis(method_a, method_b)
summary(ba)

}
