% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_rules.R
\name{suggest_rules}
\alias{suggest_rules}
\alias{suggest_all}
\alias{write_all_suggestions}
\title{Suggest rules}
\usage{
suggest_rules(
  d,
  vars = names(d),
  domain_check = TRUE,
  range_check = TRUE,
  pos_check = TRUE,
  type_check = TRUE,
  na_check = TRUE,
  unique_check = TRUE,
  ratio_check = TRUE,
  conditional_rule = TRUE
)

suggest_all(
  d,
  vars = names(d),
  domain_check = TRUE,
  range_check = TRUE,
  pos_check = TRUE,
  type_check = TRUE,
  na_check = TRUE,
  unique_check = TRUE,
  ratio_check = TRUE,
  conditional_rule = TRUE
)

write_all_suggestions(
  d,
  vars = names(d),
  file = stdout(),
  domain_check = TRUE,
  range_check = TRUE,
  type_check = TRUE,
  pos_check = TRUE,
  na_check = TRUE,
  unique_check = TRUE,
  ratio_check = TRUE,
  conditional_rule = TRUE
)
}
\arguments{
\item{d}{\code{data.frame}, used to generate the checks}

\item{vars}{\code{character} optionally the subset of variables to be used.}

\item{domain_check}{if \code{TRUE} include domain_check}

\item{range_check}{if \code{TRUE} include range_check}

\item{pos_check}{if \code{TRUE} include pos_check}

\item{type_check}{if \code{TRUE} include type_check}

\item{na_check}{if \code{TRUE} include na_check}

\item{unique_check}{if \code{TRUE} include unique_check}

\item{ratio_check}{if \code{TRUE} include ratio_check}

\item{conditional_rule}{if \code{TRUE} include cond_rule}

\item{file}{file to which the checks will be written to.}
}
\value{
returns \code{\link[validate:validator]{validate::validator()}} object with the suggested rules.
\code{write_all_suggestions} write the rules to file and returns invisibly a named list of ranges for each variable.
}
\description{
Suggests rules using the various suggestion checks.
Use the more specific \code{suggest} functions for more control.
}
