% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/uptimerobot.monitor.logs.R
\name{uptimerobot.monitor.logs}
\alias{uptimerobot.monitor.logs}
\title{Get log records for one or more monitors}
\usage{
uptimerobot.monitor.logs(api.key, monitors, limit = 50, offset = 0)
}
\arguments{
\item{api.key}{A valid key for connecting to UptimeRobors public API.}

\item{monitors}{vector or comma-delimited string with the IDs of the monitors to get.}

\item{limit}{An integer value used for pagination. Defines the max number of records to return in each page. Default and max. is 50.}

\item{offset}{An integer value to set the index of the first monitor to get (used for pagination).}
}
\value{
A dataset with the log events for the given monitors.
}
\description{
\code{uptimerobot.monitor.logs} return a dataset with all logged messages
for the given monitors IDs.
}
\details{
The API uses pagination and returns no more than 50 monitors on each page. Use \code{limit} and \code{offset} to set a different number of
monitors to get on each page and to move between pages. Leave default values to get all the data.
}
\examples{
\dontrun{
# Let's assume the api.key is available into the environment variable KEY
api.key <- Sys.getenv("KEY", "")

# Returns all the monitors IDs. Since the function always return a data.frame
# (even if you ask only for a column), you have to reference the column to get a character vector.
monitors.id <- uptimerobot.monitors(api.key, fields="id")$id

# Returns all the log events for the given monitors
logs.df <- uptimerobot.monitor.logs(api.key, monitors=monitors.id)
}
}
\author{
Gabriele Baldassarre
}
\seealso{
\code{\link{uptimerobot.monitors}}, \code{\link{uptimerobot.monitor.responses}}, \code{\link{uptimerobot.monitor.contacts}}
}

