% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.twoway.R
\name{residuals.twoway}
\alias{residuals.twoway}
\alias{fitted.twoway}
\title{Extract residuals from a twoway object}
\usage{
\method{residuals}{twoway}(object, nonadd = FALSE, ...)

\method{fitted}{twoway}(object, nonadd = FALSE, ...)
}
\arguments{
\item{object}{A \code{class="twoway"} object}

\item{nonadd}{If \code{TRUE}, the 1 degree of freedom term for non-additivity is subtracted from the additive residuals}

\item{...}{other arguments (unused)}
}
\value{
A numeric matrix of residuals corresponding to the data supplied to \code{twoway}

A numeric matrix of fitted values corresponding to the data supplied to \code{twoway}
}
\description{
Extract residuals from a twoway object

Extract fitted values from a twoway object
}
\examples{
data(taskRT)
task.2way <- twoway(taskRT)
residuals(task.2way)
residuals(task.2way, nonadd=TRUE)

sum(residuals(task.2way)^2)               #  SSE for additive model
sum(residuals(task.2way, nonadd=TRUE)^2)  # SSPE, non-additive model
data(taskRT)
task.2way <- twoway(taskRT)
fitted(task.2way)
fitted(task.2way, nonadd=TRUE)

}
